/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.trust_management.
 * Used by client-side stubs.
 */

package com.vmware.nsx.trust_management;

public interface Csrs extends com.vmware.vapi.bindings.Service, com.vmware.nsx.trust_management.CsrsTypes {

    /**
     * Creates a new certificate signing request (CSR). A CSR is encrypted text that
     * contains information about your organization (organization name, country, and so
     * on) and your Web server's public key, which is a public certificate the is
     * generated on the server that can be used to forward this request to a
     * certificate authority (CA). A private key is also usually created at the same
     * time as the CSR.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param csr (required)
     * @return com.vmware.nsx.model.Csr
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.Csr create(com.vmware.nsx.model.Csr csr);

    /**
     * Creates a new certificate signing request (CSR). A CSR is encrypted text that
     * contains information about your organization (organization name, country, and so
     * on) and your Web server's public key, which is a public certificate the is
     * generated on the server that can be used to forward this request to a
     * certificate authority (CA). A private key is also usually created at the same
     * time as the CSR.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param csr (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.Csr
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.Csr create(com.vmware.nsx.model.Csr csr, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new certificate signing request (CSR). A CSR is encrypted text that
     * contains information about your organization (organization name, country, and so
     * on) and your Web server's public key, which is a public certificate the is
     * generated on the server that can be used to forward this request to a
     * certificate authority (CA). A private key is also usually created at the same
     * time as the CSR.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Csr
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csr (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.Csr csr, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Csr> asyncCallback);

    /**
     * Creates a new certificate signing request (CSR). A CSR is encrypted text that
     * contains information about your organization (organization name, country, and so
     * on) and your Web server's public key, which is a public certificate the is
     * generated on the server that can be used to forward this request to a
     * certificate authority (CA). A private key is also usually created at the same
     * time as the CSR.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Csr
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csr (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.Csr csr, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Csr> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Removes a specified CSR. If a CSR is not used for verification, you can delete
     * it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param csrId ID of CSR to delete (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String csrId);

    /**
     * Removes a specified CSR. If a CSR is not used for verification, you can delete
     * it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param csrId ID of CSR to delete (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String csrId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Removes a specified CSR. If a CSR is not used for verification, you can delete
     * it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrId ID of CSR to delete (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String csrId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Removes a specified CSR. If a CSR is not used for verification, you can delete
     * it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrId ID of CSR to delete (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String csrId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the specified CSR.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param csrId ID of CSR to read (required)
     * @return com.vmware.nsx.model.Csr
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.Csr get(java.lang.String csrId);

    /**
     * Returns information about the specified CSR.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param csrId ID of CSR to read (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.Csr
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.Csr get(java.lang.String csrId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the specified CSR.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Csr
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrId ID of CSR to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String csrId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Csr> asyncCallback);

    /**
     * Returns information about the specified CSR.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Csr
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrId ID of CSR to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String csrId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Csr> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Imports a certificate authority (CA)-signed certificate for a CSR. This action
     * links the certificate to the private key created by the CSR. The pem_encoded
     * string in the request body is the signed certificate provided by your CA in
     * response to the CSR that you provide to them. After this operation you can
     * delete the CSR.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param csrId CSR this certificate is associated with (required)
     * @param trustObjectData (required)
     * @return com.vmware.nsx.model.CertificateList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CertificateList importcsr(java.lang.String csrId, com.vmware.nsx.model.TrustObjectData trustObjectData);

    /**
     * Imports a certificate authority (CA)-signed certificate for a CSR. This action
     * links the certificate to the private key created by the CSR. The pem_encoded
     * string in the request body is the signed certificate provided by your CA in
     * response to the CSR that you provide to them. After this operation you can
     * delete the CSR.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param csrId CSR this certificate is associated with (required)
     * @param trustObjectData (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.CertificateList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CertificateList importcsr(java.lang.String csrId, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Imports a certificate authority (CA)-signed certificate for a CSR. This action
     * links the certificate to the private key created by the CSR. The pem_encoded
     * string in the request body is the signed certificate provided by your CA in
     * response to the CSR that you provide to them. After this operation you can
     * delete the CSR.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CertificateList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrId CSR this certificate is associated with (required)
     * @param trustObjectData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void importcsr(java.lang.String csrId, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CertificateList> asyncCallback);

    /**
     * Imports a certificate authority (CA)-signed certificate for a CSR. This action
     * links the certificate to the private key created by the CSR. The pem_encoded
     * string in the request body is the signed certificate provided by your CA in
     * response to the CSR that you provide to them. After this operation you can
     * delete the CSR.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CertificateList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrId CSR this certificate is associated with (required)
     * @param trustObjectData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void importcsr(java.lang.String csrId, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CertificateList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all of the CSRs that have been created.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.CsrList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CsrList list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about all of the CSRs that have been created.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.CsrList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CsrList list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all of the CSRs that have been created.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CsrList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CsrList> asyncCallback);

    /**
     * Returns information about all of the CSRs that have been created.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CsrList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CsrList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Self-signs the previously generated CSR. This action is similar to the import
     * certificate action, but instead of using a public certificate signed by a CA,
     * the self_sign POST action uses a certificate that is signed with NSX's own
     * private key. For validity of non-CA certificates, if a value greater than 825
     * days is provided, it will be set to 825 days. No limit is set for CA
     * certificates.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param csrId CSR this certificate is associated with (required)
     * @param daysValid Number of days the certificate will be valid, default 825 days (required)
     * @return com.vmware.nsx.model.Certificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.Certificate selfsign(java.lang.String csrId, long daysValid);

    /**
     * Self-signs the previously generated CSR. This action is similar to the import
     * certificate action, but instead of using a public certificate signed by a CA,
     * the self_sign POST action uses a certificate that is signed with NSX's own
     * private key. For validity of non-CA certificates, if a value greater than 825
     * days is provided, it will be set to 825 days. No limit is set for CA
     * certificates.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param csrId CSR this certificate is associated with (required)
     * @param daysValid Number of days the certificate will be valid, default 825 days (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.Certificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.Certificate selfsign(java.lang.String csrId, long daysValid, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Self-signs the previously generated CSR. This action is similar to the import
     * certificate action, but instead of using a public certificate signed by a CA,
     * the self_sign POST action uses a certificate that is signed with NSX's own
     * private key. For validity of non-CA certificates, if a value greater than 825
     * days is provided, it will be set to 825 days. No limit is set for CA
     * certificates.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Certificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrId CSR this certificate is associated with (required)
     * @param daysValid Number of days the certificate will be valid, default 825 days (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void selfsign(java.lang.String csrId, long daysValid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Certificate> asyncCallback);

    /**
     * Self-signs the previously generated CSR. This action is similar to the import
     * certificate action, but instead of using a public certificate signed by a CA,
     * the self_sign POST action uses a certificate that is signed with NSX's own
     * private key. For validity of non-CA certificates, if a value greater than 825
     * days is provided, it will be set to 825 days. No limit is set for CA
     * certificates.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Certificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrId CSR this certificate is associated with (required)
     * @param daysValid Number of days the certificate will be valid, default 825 days (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void selfsign(java.lang.String csrId, long daysValid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Certificate> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Creates a new self-signed certificate. A private key is also created at the same
     * time. This is convenience call that will generate a CSR and then self-sign it.
     * For validity of non-CA certificates, if a value greater than 825 days is
     * provided, it will be set to 825 days. No limit is set for CA certificates.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param csrWithDaysValid (required)
     * @return com.vmware.nsx.model.Certificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.Certificate selfsign0(com.vmware.nsx.model.CsrWithDaysValid csrWithDaysValid);

    /**
     * Creates a new self-signed certificate. A private key is also created at the same
     * time. This is convenience call that will generate a CSR and then self-sign it.
     * For validity of non-CA certificates, if a value greater than 825 days is
     * provided, it will be set to 825 days. No limit is set for CA certificates.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param csrWithDaysValid (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.Certificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.Certificate selfsign0(com.vmware.nsx.model.CsrWithDaysValid csrWithDaysValid, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new self-signed certificate. A private key is also created at the same
     * time. This is convenience call that will generate a CSR and then self-sign it.
     * For validity of non-CA certificates, if a value greater than 825 days is
     * provided, it will be set to 825 days. No limit is set for CA certificates.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Certificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrWithDaysValid (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void selfsign0(com.vmware.nsx.model.CsrWithDaysValid csrWithDaysValid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Certificate> asyncCallback);

    /**
     * Creates a new self-signed certificate. A private key is also created at the same
     * time. This is convenience call that will generate a CSR and then self-sign it.
     * For validity of non-CA certificates, if a value greater than 825 days is
     * provided, it will be set to 825 days. No limit is set for CA certificates.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.Certificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param csrWithDaysValid (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void selfsign0(com.vmware.nsx.model.CsrWithDaysValid csrWithDaysValid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.Certificate> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
