/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.trust_management.certificates.action.
 * Used by client-side stubs.
 */

package com.vmware.nsx.trust_management.certificates.action;

public interface ReplaceHostCertificate extends com.vmware.vapi.bindings.Service, com.vmware.nsx.trust_management.certificates.action.ReplaceHostCertificateTypes {

    /**
     * Sends a new private-public certificate or a chain of certificates (CAs) and a
     * private key to be used on a Transport Node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param hostId The host-id for which this certificate is meant. (required)
     * @param trustObjectData (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String hostId, com.vmware.nsx.model.TrustObjectData trustObjectData);

    /**
     * Sends a new private-public certificate or a chain of certificates (CAs) and a
     * private key to be used on a Transport Node.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param hostId The host-id for which this certificate is meant. (required)
     * @param trustObjectData (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String hostId, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Sends a new private-public certificate or a chain of certificates (CAs) and a
     * private key to be used on a Transport Node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param hostId The host-id for which this certificate is meant. (required)
     * @param trustObjectData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String hostId, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Sends a new private-public certificate or a chain of certificates (CAs) and a
     * private key to be used on a Transport Node.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param hostId The host-id for which this certificate is meant. (required)
     * @param trustObjectData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String hostId, com.vmware.nsx.model.TrustObjectData trustObjectData, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
