/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.upgrade.
 * Used by client-side stubs.
 */

package com.vmware.nsx.upgrade;

public interface Bundles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.upgrade.BundlesTypes {

    /**
     * Cancel upload of upgrade bundle. This API works only when bundle upload is
     * in-progress and will not work during post-processing of upgrade bundle. If
     * bundle upload is in-progress, then the API call returns http OK response after
     * cancelling the upload and deleting partially uploaded bundle.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param bundleId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void cancelupload(java.lang.String bundleId);

    /**
     * Cancel upload of upgrade bundle. This API works only when bundle upload is
     * in-progress and will not work during post-processing of upgrade bundle. If
     * bundle upload is in-progress, then the API call returns http OK response after
     * cancelling the upload and deleting partially uploaded bundle.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param bundleId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void cancelupload(java.lang.String bundleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Cancel upload of upgrade bundle. This API works only when bundle upload is
     * in-progress and will not work during post-processing of upgrade bundle. If
     * bundle upload is in-progress, then the API call returns http OK response after
     * cancelling the upload and deleting partially uploaded bundle.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param bundleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void cancelupload(java.lang.String bundleId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Cancel upload of upgrade bundle. This API works only when bundle upload is
     * in-progress and will not work during post-processing of upgrade bundle. If
     * bundle upload is in-progress, then the API call returns http OK response after
     * cancelling the upload and deleting partially uploaded bundle.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param bundleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void cancelupload(java.lang.String bundleId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Fetches the upgrade bundle from url. The call returns after fetch is initiated.
     * Check status by periodically retrieving upgrade bundle upload status using GET
     * /upgrade/bundles/<bundle-id>/upload-status. The upload is complete when the
     * status is SUCCESS.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param upgradeBundleFetchRequest (required)
     * @param install Hint to install the bundle after upload. (optional)
     * @return com.vmware.nsx.model.UpgradeBundleId
     * @throws com.vmware.vapi.std.errors.Unauthenticated Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeBundleId create(com.vmware.nsx.model.UpgradeBundleFetchRequest upgradeBundleFetchRequest, java.lang.Boolean install);

    /**
     * Fetches the upgrade bundle from url. The call returns after fetch is initiated.
     * Check status by periodically retrieving upgrade bundle upload status using GET
     * /upgrade/bundles/<bundle-id>/upload-status. The upload is complete when the
     * status is SUCCESS.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param upgradeBundleFetchRequest (required)
     * @param install Hint to install the bundle after upload. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeBundleId
     * @throws com.vmware.vapi.std.errors.Unauthenticated Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeBundleId create(com.vmware.nsx.model.UpgradeBundleFetchRequest upgradeBundleFetchRequest, java.lang.Boolean install, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Fetches the upgrade bundle from url. The call returns after fetch is initiated.
     * Check status by periodically retrieving upgrade bundle upload status using GET
     * /upgrade/bundles/<bundle-id>/upload-status. The upload is complete when the
     * status is SUCCESS.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeBundleId
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} - Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeBundleFetchRequest (required)
     * @param install Hint to install the bundle after upload. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.UpgradeBundleFetchRequest upgradeBundleFetchRequest, java.lang.Boolean install, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeBundleId> asyncCallback);

    /**
     * Fetches the upgrade bundle from url. The call returns after fetch is initiated.
     * Check status by periodically retrieving upgrade bundle upload status using GET
     * /upgrade/bundles/<bundle-id>/upload-status. The upload is complete when the
     * status is SUCCESS.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeBundleId
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} - Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeBundleFetchRequest (required)
     * @param install Hint to install the bundle after upload. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.UpgradeBundleFetchRequest upgradeBundleFetchRequest, java.lang.Boolean install, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeBundleId> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get uploaded upgrade bundle information
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param bundleId (required)
     * @return com.vmware.nsx.model.UpgradeBundleInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeBundleInfo get(java.lang.String bundleId);

    /**
     * Get uploaded upgrade bundle information
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param bundleId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeBundleInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeBundleInfo get(java.lang.String bundleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get uploaded upgrade bundle information
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeBundleInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param bundleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String bundleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeBundleInfo> asyncCallback);

    /**
     * Get uploaded upgrade bundle information
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeBundleInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param bundleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String bundleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeBundleInfo> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
