/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.upgrade.
 * Used by client-side stubs.
 */

package com.vmware.nsx.upgrade;

public interface FilterUnits extends com.vmware.vapi.bindings.Service, com.vmware.nsx.upgrade.FilterUnitsTypes {

    /**
     * Get all the upgrade unit groups based in the filter applied. The filter can be
     * on component type, group name, id,enabled, status, unit name, unit IP, status,
     * Hypervisor.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Component type based on which upgrade units to be filtered (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param groupId Identifier of group based on which upgrade units to be filtered (optional)
     * @param groupName Group name to be filtered (optional)
     * @param hypervisor Hypervisor to be filtered for the upgrade unit (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param status Status of the upgrade unit to filtered (optional)
     * @param unitIp IP of the upgrade unit to be filtered (optional)
     * @param unitName Unit name to be filtered for the group (optional)
     * @return com.vmware.nsx.model.UpgradeUnitAggregateInfoListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitAggregateInfoListResult list(java.lang.String componentType, java.lang.String cursor, java.lang.String groupId, java.lang.String groupName, java.lang.String hypervisor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.String unitIp, java.lang.String unitName);

    /**
     * Get all the upgrade unit groups based in the filter applied. The filter can be
     * on component type, group name, id,enabled, status, unit name, unit IP, status,
     * Hypervisor.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Component type based on which upgrade units to be filtered (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param groupId Identifier of group based on which upgrade units to be filtered (optional)
     * @param groupName Group name to be filtered (optional)
     * @param hypervisor Hypervisor to be filtered for the upgrade unit (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param status Status of the upgrade unit to filtered (optional)
     * @param unitIp IP of the upgrade unit to be filtered (optional)
     * @param unitName Unit name to be filtered for the group (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnitAggregateInfoListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitAggregateInfoListResult list(java.lang.String componentType, java.lang.String cursor, java.lang.String groupId, java.lang.String groupName, java.lang.String hypervisor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.String unitIp, java.lang.String unitName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get all the upgrade unit groups based in the filter applied. The filter can be
     * on component type, group name, id,enabled, status, unit name, unit IP, status,
     * Hypervisor.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitAggregateInfoListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param componentType Component type based on which upgrade units to be filtered (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param groupId Identifier of group based on which upgrade units to be filtered (optional)
     * @param groupName Group name to be filtered (optional)
     * @param hypervisor Hypervisor to be filtered for the upgrade unit (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param status Status of the upgrade unit to filtered (optional)
     * @param unitIp IP of the upgrade unit to be filtered (optional)
     * @param unitName Unit name to be filtered for the group (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String componentType, java.lang.String cursor, java.lang.String groupId, java.lang.String groupName, java.lang.String hypervisor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.String unitIp, java.lang.String unitName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitAggregateInfoListResult> asyncCallback);

    /**
     * Get all the upgrade unit groups based in the filter applied. The filter can be
     * on component type, group name, id,enabled, status, unit name, unit IP, status,
     * Hypervisor.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitAggregateInfoListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param componentType Component type based on which upgrade units to be filtered (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param groupId Identifier of group based on which upgrade units to be filtered (optional)
     * @param groupName Group name to be filtered (optional)
     * @param hypervisor Hypervisor to be filtered for the upgrade unit (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param status Status of the upgrade unit to filtered (optional)
     * @param unitIp IP of the upgrade unit to be filtered (optional)
     * @param unitName Unit name to be filtered for the group (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String componentType, java.lang.String cursor, java.lang.String groupId, java.lang.String groupName, java.lang.String hypervisor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String status, java.lang.String unitIp, java.lang.String unitName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitAggregateInfoListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
