/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.upgrade.
 * Used by client-side stubs.
 */

package com.vmware.nsx.upgrade;

public interface UpgradeUnits extends com.vmware.vapi.bindings.Service, com.vmware.nsx.upgrade.UpgradeUnitsTypes {

    /**
     * Get a specific upgrade unit
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param upgradeUnitId (required)
     * @return com.vmware.nsx.model.UpgradeUnit
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnit get(java.lang.String upgradeUnitId);

    /**
     * Get a specific upgrade unit
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param upgradeUnitId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnit
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnit get(java.lang.String upgradeUnitId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get a specific upgrade unit
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnit
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeUnitId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String upgradeUnitId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnit> asyncCallback);

    /**
     * Get a specific upgrade unit
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnit
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeUnitId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String upgradeUnitId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnit> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get upgrade units
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Component type based on which upgrade units to be filtered (optional)
     * @param currentVersion Current version of upgrade unit based on which upgrade units to be filtered
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param groupId UUID of group based on which upgrade units to be filtered (optional)
     * @param hasWarnings Flag to indicate whether to return only upgrade units with warnings (optional,
     * default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param metadata Metadata about upgrade unit to filter on (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param upgradeUnitType Upgrade unit type based on which upgrade units to be filtered (optional)
     * @return com.vmware.nsx.model.UpgradeUnitListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitListResult list(java.lang.String componentType, java.lang.String currentVersion, java.lang.String cursor, java.lang.String groupId, java.lang.Boolean hasWarnings, java.lang.String includedFields, java.lang.String metadata, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String upgradeUnitType);

    /**
     * Get upgrade units
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Component type based on which upgrade units to be filtered (optional)
     * @param currentVersion Current version of upgrade unit based on which upgrade units to be filtered
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param groupId UUID of group based on which upgrade units to be filtered (optional)
     * @param hasWarnings Flag to indicate whether to return only upgrade units with warnings (optional,
     * default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param metadata Metadata about upgrade unit to filter on (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param upgradeUnitType Upgrade unit type based on which upgrade units to be filtered (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnitListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitListResult list(java.lang.String componentType, java.lang.String currentVersion, java.lang.String cursor, java.lang.String groupId, java.lang.Boolean hasWarnings, java.lang.String includedFields, java.lang.String metadata, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String upgradeUnitType, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get upgrade units
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param componentType Component type based on which upgrade units to be filtered (optional)
     * @param currentVersion Current version of upgrade unit based on which upgrade units to be filtered
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param groupId UUID of group based on which upgrade units to be filtered (optional)
     * @param hasWarnings Flag to indicate whether to return only upgrade units with warnings (optional,
     * default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param metadata Metadata about upgrade unit to filter on (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param upgradeUnitType Upgrade unit type based on which upgrade units to be filtered (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String componentType, java.lang.String currentVersion, java.lang.String cursor, java.lang.String groupId, java.lang.Boolean hasWarnings, java.lang.String includedFields, java.lang.String metadata, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String upgradeUnitType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitListResult> asyncCallback);

    /**
     * Get upgrade units
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param componentType Component type based on which upgrade units to be filtered (optional)
     * @param currentVersion Current version of upgrade unit based on which upgrade units to be filtered
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param groupId UUID of group based on which upgrade units to be filtered (optional)
     * @param hasWarnings Flag to indicate whether to return only upgrade units with warnings (optional,
     * default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param metadata Metadata about upgrade unit to filter on (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param upgradeUnitType Upgrade unit type based on which upgrade units to be filtered (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String componentType, java.lang.String currentVersion, java.lang.String cursor, java.lang.String groupId, java.lang.Boolean hasWarnings, java.lang.String includedFields, java.lang.String metadata, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String upgradeUnitType, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
