/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.vpn.ipsec.
 * Used by client-side stubs.
 */

package com.vmware.nsx.vpn.ipsec;

public interface TunnelProfiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.vpn.ipsec.TunnelProfilesTypes {

    /**
     * Create custom IPSec tunnel profile. IPSec tunnel profile is a reusable profile
     * that captures phase two negotiation parameters and tunnel properties. System
     * will be provisioned with system owned non editable default IPSec tunnel profile.
     * Any change in profile affects all sessions consuming this profile. <br/> <br/>
     * Please use below Policy API. <br/> PATCH
     * /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipSecVPNTunnelProfile (required)
     * @return com.vmware.nsx.model.IPSecVPNTunnelProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNTunnelProfile create(com.vmware.nsx.model.IPSecVPNTunnelProfile ipSecVPNTunnelProfile);

    /**
     * Create custom IPSec tunnel profile. IPSec tunnel profile is a reusable profile
     * that captures phase two negotiation parameters and tunnel properties. System
     * will be provisioned with system owned non editable default IPSec tunnel profile.
     * Any change in profile affects all sessions consuming this profile. <br/> <br/>
     * Please use below Policy API. <br/> PATCH
     * /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipSecVPNTunnelProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNTunnelProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNTunnelProfile create(com.vmware.nsx.model.IPSecVPNTunnelProfile ipSecVPNTunnelProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create custom IPSec tunnel profile. IPSec tunnel profile is a reusable profile
     * that captures phase two negotiation parameters and tunnel properties. System
     * will be provisioned with system owned non editable default IPSec tunnel profile.
     * Any change in profile affects all sessions consuming this profile. <br/> <br/>
     * Please use below Policy API. <br/> PATCH
     * /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNTunnelProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipSecVPNTunnelProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.IPSecVPNTunnelProfile ipSecVPNTunnelProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNTunnelProfile> asyncCallback);

    /**
     * Create custom IPSec tunnel profile. IPSec tunnel profile is a reusable profile
     * that captures phase two negotiation parameters and tunnel properties. System
     * will be provisioned with system owned non editable default IPSec tunnel profile.
     * Any change in profile affects all sessions consuming this profile. <br/> <br/>
     * Please use below Policy API. <br/> PATCH
     * /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNTunnelProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipSecVPNTunnelProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.IPSecVPNTunnelProfile ipSecVPNTunnelProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNTunnelProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete custom IPSec Tunnel Profile. <br/> <br/> Please use below Policy API.
     * <br/> DELETE /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String ipsecVpnTunnelProfileId, java.lang.Boolean force);

    /**
     * Delete custom IPSec Tunnel Profile. <br/> <br/> Please use below Policy API.
     * <br/> DELETE /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String ipsecVpnTunnelProfileId, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete custom IPSec Tunnel Profile. <br/> <br/> Please use below Policy API.
     * <br/> DELETE /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String ipsecVpnTunnelProfileId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete custom IPSec Tunnel Profile. <br/> <br/> Please use below Policy API.
     * <br/> DELETE /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String ipsecVpnTunnelProfileId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get custom IPSec Tunnel Profile. <br/> <br/> Please use below Policy API. <br/>
     * GET /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @return com.vmware.nsx.model.IPSecVPNTunnelProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNTunnelProfile get(java.lang.String ipsecVpnTunnelProfileId);

    /**
     * Get custom IPSec Tunnel Profile. <br/> <br/> Please use below Policy API. <br/>
     * GET /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNTunnelProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNTunnelProfile get(java.lang.String ipsecVpnTunnelProfileId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get custom IPSec Tunnel Profile. <br/> <br/> Please use below Policy API. <br/>
     * GET /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNTunnelProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String ipsecVpnTunnelProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNTunnelProfile> asyncCallback);

    /**
     * Get custom IPSec Tunnel Profile. <br/> <br/> Please use below Policy API. <br/>
     * GET /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNTunnelProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String ipsecVpnTunnelProfileId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNTunnelProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get paginated list of all IPSecTunnelProfiles. <br/> <br/> Please use below
     * Policy API. <br/> GET /policy/api/v1/infra/ipsec-vpn-tunnel-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.IPSecVPNTunnelProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNTunnelProfileListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Get paginated list of all IPSecTunnelProfiles. <br/> <br/> Please use below
     * Policy API. <br/> GET /policy/api/v1/infra/ipsec-vpn-tunnel-profiles
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNTunnelProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNTunnelProfileListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get paginated list of all IPSecTunnelProfiles. <br/> <br/> Please use below
     * Policy API. <br/> GET /policy/api/v1/infra/ipsec-vpn-tunnel-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNTunnelProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNTunnelProfileListResult> asyncCallback);

    /**
     * Get paginated list of all IPSecTunnelProfiles. <br/> <br/> Please use below
     * Policy API. <br/> GET /policy/api/v1/infra/ipsec-vpn-tunnel-profiles
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNTunnelProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNTunnelProfileListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Edit custom IPSec Tunnel Profile. System owned profiles are non editable. <br/>
     * <br/> Please use below Policy API. <br/> PUT
     * /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param ipSecVPNTunnelProfile (required)
     * @return com.vmware.nsx.model.IPSecVPNTunnelProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNTunnelProfile update(java.lang.String ipsecVpnTunnelProfileId, com.vmware.nsx.model.IPSecVPNTunnelProfile ipSecVPNTunnelProfile);

    /**
     * Edit custom IPSec Tunnel Profile. System owned profiles are non editable. <br/>
     * <br/> Please use below Policy API. <br/> PUT
     * /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param ipSecVPNTunnelProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNTunnelProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNTunnelProfile update(java.lang.String ipsecVpnTunnelProfileId, com.vmware.nsx.model.IPSecVPNTunnelProfile ipSecVPNTunnelProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Edit custom IPSec Tunnel Profile. System owned profiles are non editable. <br/>
     * <br/> Please use below Policy API. <br/> PUT
     * /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNTunnelProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param ipSecVPNTunnelProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String ipsecVpnTunnelProfileId, com.vmware.nsx.model.IPSecVPNTunnelProfile ipSecVPNTunnelProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNTunnelProfile> asyncCallback);

    /**
     * Edit custom IPSec Tunnel Profile. System owned profiles are non editable. <br/>
     * <br/> Please use below Policy API. <br/> PUT
     * /policy/api/v1/infra/ipsec-vpn-tunnel-profiles/<tunnel-profile-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNTunnelProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipsecVpnTunnelProfileId (required)
     * @param ipSecVPNTunnelProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String ipsecVpnTunnelProfileId, com.vmware.nsx.model.IPSecVPNTunnelProfile ipSecVPNTunnelProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNTunnelProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
