
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.vpn.l2vpn;

/**
 * {@link L2vpnFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.vpn.l2vpn package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class L2vpnFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private L2vpnFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link L2vpnFactory} factory instance
     */
    public static L2vpnFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        L2vpnFactory instance = new L2vpnFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.l2vpn.Services}
     */
    public com.vmware.nsx.vpn.l2vpn.Services servicesService() {
        return this.stubFactory.createStub(Services.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.l2vpn.Sessions}
     */
    public com.vmware.nsx.vpn.l2vpn.Sessions sessionsService() {
        return this.stubFactory.createStub(Sessions.class, this.stubConfig);
    }

    public com.vmware.nsx.vpn.l2vpn.sessions.SessionsFactory sessions() {
        return com.vmware.nsx.vpn.l2vpn.sessions.SessionsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
