/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.aaa.ldap_identity_sources.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.aaa.ldap_identity_sources;

public interface Search extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.aaa.ldap_identity_sources.SearchTypes {

    /**
     * Search the LDAP identity source for users and groups that match the given
     * filter_value. In most cases, the LDAP source performs a case-insensitive search.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ldapIdentitySourceId (required)
     * @param filterValue Search filter value (required)
     * @return com.vmware.nsx_policy.model.LdapIdentitySourceSearchResultList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.LdapIdentitySourceSearchResultList create(java.lang.String ldapIdentitySourceId, java.lang.String filterValue);

    /**
     * Search the LDAP identity source for users and groups that match the given
     * filter_value. In most cases, the LDAP source performs a case-insensitive search.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ldapIdentitySourceId (required)
     * @param filterValue Search filter value (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.LdapIdentitySourceSearchResultList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.LdapIdentitySourceSearchResultList create(java.lang.String ldapIdentitySourceId, java.lang.String filterValue, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Search the LDAP identity source for users and groups that match the given
     * filter_value. In most cases, the LDAP source performs a case-insensitive search.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.LdapIdentitySourceSearchResultList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param filterValue Search filter value (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String ldapIdentitySourceId, java.lang.String filterValue, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.LdapIdentitySourceSearchResultList> asyncCallback);

    /**
     * Search the LDAP identity source for users and groups that match the given
     * filter_value. In most cases, the LDAP source performs a case-insensitive search.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.LdapIdentitySourceSearchResultList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param filterValue Search filter value (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String ldapIdentitySourceId, java.lang.String filterValue, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.LdapIdentitySourceSearchResultList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
