/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.alb.controller_nodes.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.alb.controller_nodes;

public interface Deployments extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.alb.controller_nodes.DeploymentsTypes {

    /**
     * Deploys a Advanced Load Balancer controller node VM as specified by the
     * deployment config.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param addALBControllerNodeVMInfo (required)
     * @return com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList create(com.vmware.nsx_policy.model.AddALBControllerNodeVMInfo addALBControllerNodeVMInfo);

    /**
     * Deploys a Advanced Load Balancer controller node VM as specified by the
     * deployment config.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param addALBControllerNodeVMInfo (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList create(com.vmware.nsx_policy.model.AddALBControllerNodeVMInfo addALBControllerNodeVMInfo, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deploys a Advanced Load Balancer controller node VM as specified by the
     * deployment config.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param addALBControllerNodeVMInfo (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx_policy.model.AddALBControllerNodeVMInfo addALBControllerNodeVMInfo, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList> asyncCallback);

    /**
     * Deploys a Advanced Load Balancer controller node VM as specified by the
     * deployment config.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param addALBControllerNodeVMInfo (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx_policy.model.AddALBControllerNodeVMInfo addALBControllerNodeVMInfo, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Attempts to unregister and undeploy a specified auto-deployed cluster node VM.
     * If it is a member of a cluster, then the VM will be automatically detached from
     * the cluster before being unregistered and undeployed. Alternatively, if the
     * original deployment attempt failed or the VM is not found, cleans up the
     * deployment information associated with the deployment attempt. Note: If a VM has
     * been successfully auto-deployed, then the associated deployment information will
     * not be deleted unless and until the VM is successfully deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeId (required)
     * @param forceDelete Delete by force (optional)
     * @param inaccessible Delete when controller is inaccessible (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String nodeId, java.lang.Boolean forceDelete, java.lang.String inaccessible);

    /**
     * Attempts to unregister and undeploy a specified auto-deployed cluster node VM.
     * If it is a member of a cluster, then the VM will be automatically detached from
     * the cluster before being unregistered and undeployed. Alternatively, if the
     * original deployment attempt failed or the VM is not found, cleans up the
     * deployment information associated with the deployment attempt. Note: If a VM has
     * been successfully auto-deployed, then the associated deployment information will
     * not be deleted unless and until the VM is successfully deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeId (required)
     * @param forceDelete Delete by force (optional)
     * @param inaccessible Delete when controller is inaccessible (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String nodeId, java.lang.Boolean forceDelete, java.lang.String inaccessible, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Attempts to unregister and undeploy a specified auto-deployed cluster node VM.
     * If it is a member of a cluster, then the VM will be automatically detached from
     * the cluster before being unregistered and undeployed. Alternatively, if the
     * original deployment attempt failed or the VM is not found, cleans up the
     * deployment information associated with the deployment attempt. Note: If a VM has
     * been successfully auto-deployed, then the associated deployment information will
     * not be deleted unless and until the VM is successfully deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param forceDelete Delete by force (optional)
     * @param inaccessible Delete when controller is inaccessible (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String nodeId, java.lang.Boolean forceDelete, java.lang.String inaccessible, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Attempts to unregister and undeploy a specified auto-deployed cluster node VM.
     * If it is a member of a cluster, then the VM will be automatically detached from
     * the cluster before being unregistered and undeployed. Alternatively, if the
     * original deployment attempt failed or the VM is not found, cleans up the
     * deployment information associated with the deployment attempt. Note: If a VM has
     * been successfully auto-deployed, then the associated deployment information will
     * not be deleted unless and until the VM is successfully deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param forceDelete Delete by force (optional)
     * @param inaccessible Delete when controller is inaccessible (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String nodeId, java.lang.Boolean forceDelete, java.lang.String inaccessible, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns deployment request information for a specific attempted deployment of a
     * cluster node VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeId (required)
     * @return com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest get(java.lang.String nodeId);

    /**
     * Returns deployment request information for a specific attempted deployment of a
     * cluster node VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest get(java.lang.String nodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns deployment request information for a specific attempted deployment of a
     * cluster node VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String nodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest> asyncCallback);

    /**
     * Returns deployment request information for a specific attempted deployment of a
     * cluster node VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String nodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns request information for every attempted deployment of a cluster node VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param state the current state of the Advanced Load Balancer controller VM (optional)
     * @return com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList list(java.lang.String clusteringId, java.lang.String state);

    /**
     * Returns request information for every attempted deployment of a cluster node VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param state the current state of the Advanced Load Balancer controller VM (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList list(java.lang.String clusteringId, java.lang.String state, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns request information for every attempted deployment of a cluster node VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param state the current state of the Advanced Load Balancer controller VM (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String clusteringId, java.lang.String state, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList> asyncCallback);

    /**
     * Returns request information for every attempted deployment of a cluster node VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param state the current state of the Advanced Load Balancer controller VM (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String clusteringId, java.lang.String state, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequestList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update Advanced Load Balancer Controller node VM details
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeId (required)
     * @param aLBControllerNodeVMDeploymentRequest (required)
     * @param runningConfig Update Advanced Load Balancer Controller runtime config as well (optional)
     * @return com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest update(java.lang.String nodeId, com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest aLBControllerNodeVMDeploymentRequest, java.lang.Boolean runningConfig);

    /**
     * Update Advanced Load Balancer Controller node VM details
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeId (required)
     * @param aLBControllerNodeVMDeploymentRequest (required)
     * @param runningConfig Update Advanced Load Balancer Controller runtime config as well (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest update(java.lang.String nodeId, com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest aLBControllerNodeVMDeploymentRequest, java.lang.Boolean runningConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update Advanced Load Balancer Controller node VM details
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param aLBControllerNodeVMDeploymentRequest (required)
     * @param runningConfig Update Advanced Load Balancer Controller runtime config as well (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String nodeId, com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest aLBControllerNodeVMDeploymentRequest, java.lang.Boolean runningConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest> asyncCallback);

    /**
     * Update Advanced Load Balancer Controller node VM details
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param aLBControllerNodeVMDeploymentRequest (required)
     * @param runningConfig Update Advanced Load Balancer Controller runtime config as well (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String nodeId, com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest aLBControllerNodeVMDeploymentRequest, java.lang.Boolean runningConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerNodeVMDeploymentRequest> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
