/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.global_infra.tier_1s.segments.ports.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.global_infra.tier_1s.segments.ports;

public interface PortSecurityProfileBindingMaps extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.global_infra.tier_1s.segments.ports.PortSecurityProfileBindingMapsTypes {

    /**
     * API will delete the port security profile binding map.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId);

    /**
     * API will delete the port security profile binding map.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will delete the port security profile binding map.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * API will delete the port security profile binding map.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * API will return details of the port security profile binding map. If the
     * security profile binding map does not exist, it will return 404.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @return com.vmware.nsx_policy.model.PortSecurityProfileBindingMap
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PortSecurityProfileBindingMap get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId);

    /**
     * API will return details of the port security profile binding map. If the
     * security profile binding map does not exist, it will return 404.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PortSecurityProfileBindingMap
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PortSecurityProfileBindingMap get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will return details of the port security profile binding map. If the
     * security profile binding map does not exist, it will return 404.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PortSecurityProfileBindingMap
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PortSecurityProfileBindingMap> asyncCallback);

    /**
     * API will return details of the port security profile binding map. If the
     * security profile binding map does not exist, it will return 404.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PortSecurityProfileBindingMap
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PortSecurityProfileBindingMap> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * API will list all port security profile binding maps.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.PortSecurityProfileBindingMapListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PortSecurityProfileBindingMapListResult list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * API will list all port security profile binding maps.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PortSecurityProfileBindingMapListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PortSecurityProfileBindingMapListResult list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will list all port security profile binding maps.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PortSecurityProfileBindingMapListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PortSecurityProfileBindingMapListResult> asyncCallback);

    /**
     * API will list all port security profile binding maps.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PortSecurityProfileBindingMapListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PortSecurityProfileBindingMapListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create a new port security profile binding map if the given security profile
     * binding map does not exist. Otherwise, patch the existing port security profile
     * binding map. For objects with no binding maps, default profile is applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param portSecurityProfileBindingMap (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.nsx_policy.model.PortSecurityProfileBindingMap portSecurityProfileBindingMap);

    /**
     * Create a new port security profile binding map if the given security profile
     * binding map does not exist. Otherwise, patch the existing port security profile
     * binding map. For objects with no binding maps, default profile is applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param portSecurityProfileBindingMap (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.nsx_policy.model.PortSecurityProfileBindingMap portSecurityProfileBindingMap, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a new port security profile binding map if the given security profile
     * binding map does not exist. Otherwise, patch the existing port security profile
     * binding map. For objects with no binding maps, default profile is applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param portSecurityProfileBindingMap (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.nsx_policy.model.PortSecurityProfileBindingMap portSecurityProfileBindingMap, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create a new port security profile binding map if the given security profile
     * binding map does not exist. Otherwise, patch the existing port security profile
     * binding map. For objects with no binding maps, default profile is applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param portSecurityProfileBindingMap (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.nsx_policy.model.PortSecurityProfileBindingMap portSecurityProfileBindingMap, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * API will create or replace the port security profile binding map. For objects
     * with no binding maps, default profile is applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param portSecurityProfileBindingMap (required)
     * @return com.vmware.nsx_policy.model.PortSecurityProfileBindingMap
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PortSecurityProfileBindingMap update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.nsx_policy.model.PortSecurityProfileBindingMap portSecurityProfileBindingMap);

    /**
     * API will create or replace the port security profile binding map. For objects
     * with no binding maps, default profile is applied.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param portSecurityProfileBindingMap (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PortSecurityProfileBindingMap
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PortSecurityProfileBindingMap update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.nsx_policy.model.PortSecurityProfileBindingMap portSecurityProfileBindingMap, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API will create or replace the port security profile binding map. For objects
     * with no binding maps, default profile is applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PortSecurityProfileBindingMap
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param portSecurityProfileBindingMap (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.nsx_policy.model.PortSecurityProfileBindingMap portSecurityProfileBindingMap, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PortSecurityProfileBindingMap> asyncCallback);

    /**
     * API will create or replace the port security profile binding map. For objects
     * with no binding maps, default profile is applied.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PortSecurityProfileBindingMap
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id tier-1 gateway id (required)
     * @param segmentId segment id (required)
     * @param portId port id (required)
     * @param portSecurityProfileBindingMapId port security profile binding map id (required)
     * @param portSecurityProfileBindingMap (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String tier1Id, java.lang.String segmentId, java.lang.String portId, java.lang.String portSecurityProfileBindingMapId, com.vmware.nsx_policy.model.PortSecurityProfileBindingMap portSecurityProfileBindingMap, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PortSecurityProfileBindingMap> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
