/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra;

public interface Drafts extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.DraftsTypes {

    /**
     * Delete a manual draft.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param draftId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String draftId);

    /**
     * Delete a manual draft.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param draftId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String draftId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete a manual draft.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String draftId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete a manual draft.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String draftId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read a draft for a given draft identifier.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param draftId (required)
     * @return com.vmware.nsx_policy.model.PolicyDraft
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDraft get(java.lang.String draftId);

    /**
     * Read a draft for a given draft identifier.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param draftId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyDraft
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDraft get(java.lang.String draftId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read a draft for a given draft identifier.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDraft
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String draftId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDraft> asyncCallback);

    /**
     * Read a draft for a given draft identifier.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDraft
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String draftId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDraft> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List policy drafts.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param autoDrafts Fetch list of draft based on is_auto_draft flag (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.PolicyDraftListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDraftListResult list(java.lang.Boolean autoDrafts, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List policy drafts.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param autoDrafts Fetch list of draft based on is_auto_draft flag (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyDraftListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDraftListResult list(java.lang.Boolean autoDrafts, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List policy drafts.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDraftListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param autoDrafts Fetch list of draft based on is_auto_draft flag (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.Boolean autoDrafts, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDraftListResult> asyncCallback);

    /**
     * List policy drafts.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDraftListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param autoDrafts Fetch list of draft based on is_auto_draft flag (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.Boolean autoDrafts, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDraftListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create a new manual draft if the specified draft id does not correspond to an
     * existing draft. Update the manual draft otherwise. Auto draft can not be
     * updated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param draftId (required)
     * @param policyDraft (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String draftId, com.vmware.nsx_policy.model.PolicyDraft policyDraft);

    /**
     * Create a new manual draft if the specified draft id does not correspond to an
     * existing draft. Update the manual draft otherwise. Auto draft can not be
     * updated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param draftId (required)
     * @param policyDraft (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String draftId, com.vmware.nsx_policy.model.PolicyDraft policyDraft, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a new manual draft if the specified draft id does not correspond to an
     * existing draft. Update the manual draft otherwise. Auto draft can not be
     * updated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param policyDraft (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String draftId, com.vmware.nsx_policy.model.PolicyDraft policyDraft, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create a new manual draft if the specified draft id does not correspond to an
     * existing draft. Update the manual draft otherwise. Auto draft can not be
     * updated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param policyDraft (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String draftId, com.vmware.nsx_policy.model.PolicyDraft policyDraft, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read a draft and publish it by applying changes onto current configuration. If
     * there are additional changes on top of draft configuration, pass it as a request
     * body, in form of Infra object. Otherwise, if there are no additional changes,
     * then pass empty Infra object as a request body.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param draftId (required)
     * @param infra (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void publish(java.lang.String draftId, com.vmware.nsx_policy.model.Infra infra);

    /**
     * Read a draft and publish it by applying changes onto current configuration. If
     * there are additional changes on top of draft configuration, pass it as a request
     * body, in form of Infra object. Otherwise, if there are no additional changes,
     * then pass empty Infra object as a request body.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param draftId (required)
     * @param infra (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void publish(java.lang.String draftId, com.vmware.nsx_policy.model.Infra infra, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read a draft and publish it by applying changes onto current configuration. If
     * there are additional changes on top of draft configuration, pass it as a request
     * body, in form of Infra object. Otherwise, if there are no additional changes,
     * then pass empty Infra object as a request body.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param infra (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void publish(java.lang.String draftId, com.vmware.nsx_policy.model.Infra infra, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Read a draft and publish it by applying changes onto current configuration. If
     * there are additional changes on top of draft configuration, pass it as a request
     * body, in form of Infra object. Otherwise, if there are no additional changes,
     * then pass empty Infra object as a request body.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param infra (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void publish(java.lang.String draftId, com.vmware.nsx_policy.model.Infra infra, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create a new manual draft if the specified draft id does not correspond to an
     * existing draft. Update the manual draft otherwise. Auto draft can not be
     * updated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param draftId (required)
     * @param policyDraft (required)
     * @return com.vmware.nsx_policy.model.PolicyDraft
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDraft update(java.lang.String draftId, com.vmware.nsx_policy.model.PolicyDraft policyDraft);

    /**
     * Create a new manual draft if the specified draft id does not correspond to an
     * existing draft. Update the manual draft otherwise. Auto draft can not be
     * updated.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param draftId (required)
     * @param policyDraft (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PolicyDraft
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PolicyDraft update(java.lang.String draftId, com.vmware.nsx_policy.model.PolicyDraft policyDraft, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a new manual draft if the specified draft id does not correspond to an
     * existing draft. Update the manual draft otherwise. Auto draft can not be
     * updated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDraft
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param policyDraft (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String draftId, com.vmware.nsx_policy.model.PolicyDraft policyDraft, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDraft> asyncCallback);

    /**
     * Create a new manual draft if the specified draft id does not correspond to an
     * existing draft. Update the manual draft otherwise. Auto draft can not be
     * updated.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PolicyDraft
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param draftId (required)
     * @param policyDraft (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String draftId, com.vmware.nsx_policy.model.PolicyDraft policyDraft, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PolicyDraft> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
