/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra;

public interface Tags extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.TagsTypes {

    /**
     * Returns paginated list of all unique tags. Supports filtering by scope, tag and
     * source from which tags are synced. Supports starts with, ends with, equals and
     * contains operators on scope and tag values. To filter tags by starts with on
     * scope or tag, use '*' as suffix after the value. To filter tags by ends with on
     * scope or tag, use '*' as prefix before the value. To filter tags by contain on
     * scope or tag, use '*' as prefix and suffix on the value. Below special
     * characters in the filter value needs to be escaped with hex values. - Character
     * '&' needs to be escaped as '%26' - Character '[' needs to be escaped as '%5B' -
     * Character ']' needs to be escaped as '%5D' - Character '+' needs to be escaped
     * as '%2B' - Character '#' needs to be escaped as '%23' Sort option for list of
     * unique tags is available only on tag and scope properties.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param scope Tag scope (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Source from which tags are synced. (optional)
     * @param tag Tag value (optional)
     * @return com.vmware.nsx_policy.model.TagInfoListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TagInfoListResult list(java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String scope, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String tag);

    /**
     * Returns paginated list of all unique tags. Supports filtering by scope, tag and
     * source from which tags are synced. Supports starts with, ends with, equals and
     * contains operators on scope and tag values. To filter tags by starts with on
     * scope or tag, use '*' as suffix after the value. To filter tags by ends with on
     * scope or tag, use '*' as prefix before the value. To filter tags by contain on
     * scope or tag, use '*' as prefix and suffix on the value. Below special
     * characters in the filter value needs to be escaped with hex values. - Character
     * '&' needs to be escaped as '%26' - Character '[' needs to be escaped as '%5B' -
     * Character ']' needs to be escaped as '%5D' - Character '+' needs to be escaped
     * as '%2B' - Character '#' needs to be escaped as '%23' Sort option for list of
     * unique tags is available only on tag and scope properties.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param scope Tag scope (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Source from which tags are synced. (optional)
     * @param tag Tag value (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.TagInfoListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TagInfoListResult list(java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String scope, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String tag, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns paginated list of all unique tags. Supports filtering by scope, tag and
     * source from which tags are synced. Supports starts with, ends with, equals and
     * contains operators on scope and tag values. To filter tags by starts with on
     * scope or tag, use '*' as suffix after the value. To filter tags by ends with on
     * scope or tag, use '*' as prefix before the value. To filter tags by contain on
     * scope or tag, use '*' as prefix and suffix on the value. Below special
     * characters in the filter value needs to be escaped with hex values. - Character
     * '&' needs to be escaped as '%26' - Character '[' needs to be escaped as '%5B' -
     * Character ']' needs to be escaped as '%5D' - Character '+' needs to be escaped
     * as '%2B' - Character '#' needs to be escaped as '%23' Sort option for list of
     * unique tags is available only on tag and scope properties.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TagInfoListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param scope Tag scope (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Source from which tags are synced. (optional)
     * @param tag Tag value (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String scope, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String tag, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TagInfoListResult> asyncCallback);

    /**
     * Returns paginated list of all unique tags. Supports filtering by scope, tag and
     * source from which tags are synced. Supports starts with, ends with, equals and
     * contains operators on scope and tag values. To filter tags by starts with on
     * scope or tag, use '*' as suffix after the value. To filter tags by ends with on
     * scope or tag, use '*' as prefix before the value. To filter tags by contain on
     * scope or tag, use '*' as prefix and suffix on the value. Below special
     * characters in the filter value needs to be escaped with hex values. - Character
     * '&' needs to be escaped as '%26' - Character '[' needs to be escaped as '%5B' -
     * Character ']' needs to be escaped as '%5D' - Character '+' needs to be escaped
     * as '%2B' - Character '#' needs to be escaped as '%23' Sort option for list of
     * unique tags is available only on tag and scope properties.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TagInfoListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param scope Tag scope (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Source from which tags are synced. (optional)
     * @param tag Tag value (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String scope, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String tag, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TagInfoListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
