/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.domains.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.domains;

public interface SecurityPolicies extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.domains.SecurityPoliciesTypes {

    /**
     * Deletes the security policy along with all the rules
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String domainId, java.lang.String securityPolicyId);

    /**
     * Deletes the security policy along with all the rules
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the security policy along with all the rules
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the security policy along with all the rules
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read security policy for a domain.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @return com.vmware.nsx_policy.model.SecurityPolicy
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SecurityPolicy get(java.lang.String domainId, java.lang.String securityPolicyId);

    /**
     * Read security policy for a domain.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SecurityPolicy
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SecurityPolicy get(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read security policy for a domain.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SecurityPolicy
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SecurityPolicy> asyncCallback);

    /**
     * Read security policy for a domain.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SecurityPolicy
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SecurityPolicy> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all security policies for a domain.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includeRuleCount Include the count of rules in policy (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.SecurityPolicyListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SecurityPolicyListResult list(java.lang.String domainId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.Boolean includeRuleCount, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List all security policies for a domain.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includeRuleCount Include the count of rules in policy (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SecurityPolicyListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SecurityPolicyListResult list(java.lang.String domainId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.Boolean includeRuleCount, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all security policies for a domain.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SecurityPolicyListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includeRuleCount Include the count of rules in policy (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String domainId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.Boolean includeRuleCount, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SecurityPolicyListResult> asyncCallback);

    /**
     * List all security policies for a domain.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SecurityPolicyListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includeRuleCount Include the count of rules in policy (optional, default to false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String domainId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.Boolean includeRuleCount, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SecurityPolicyListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Patch the security policy for a domain. If a security policy for the given
     * security-policy-id is not present, the object will get created and if it is
     * present it will be updated. This is a full replace. Performance Note: If you
     * want to edit several rules in a security policy use this API. It will perform
     * better than several individual rule APIs. Just pass all the rules which you wish
     * to edit as embedded rules to it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy);

    /**
     * Patch the security policy for a domain. If a security policy for the given
     * security-policy-id is not present, the object will get created and if it is
     * present it will be updated. This is a full replace. Performance Note: If you
     * want to edit several rules in a security policy use this API. It will perform
     * better than several individual rule APIs. Just pass all the rules which you wish
     * to edit as embedded rules to it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Patch the security policy for a domain. If a security policy for the given
     * security-policy-id is not present, the object will get created and if it is
     * present it will be updated. This is a full replace. Performance Note: If you
     * want to edit several rules in a security policy use this API. It will perform
     * better than several individual rule APIs. Just pass all the rules which you wish
     * to edit as embedded rules to it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Patch the security policy for a domain. If a security policy for the given
     * security-policy-id is not present, the object will get created and if it is
     * present it will be updated. This is a full replace. Performance Note: If you
     * want to edit several rules in a security policy use this API. It will perform
     * better than several individual rule APIs. Just pass all the rules which you wish
     * to edit as embedded rules to it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This is used to set a precedence of a security policy w.r.t others.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param anchorPath The security policy/rule path if operation is 'insert_after' or 'insert_before'
     * (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx_policy.model.SecurityPolicy
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SecurityPolicy revise(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, java.lang.String anchorPath, java.lang.String operation);

    /**
     * This is used to set a precedence of a security policy w.r.t others.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param anchorPath The security policy/rule path if operation is 'insert_after' or 'insert_before'
     * (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SecurityPolicy
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SecurityPolicy revise(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, java.lang.String anchorPath, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This is used to set a precedence of a security policy w.r.t others.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SecurityPolicy
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param anchorPath The security policy/rule path if operation is 'insert_after' or 'insert_before'
     * (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void revise(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, java.lang.String anchorPath, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SecurityPolicy> asyncCallback);

    /**
     * This is used to set a precedence of a security policy w.r.t others.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SecurityPolicy
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param anchorPath The security policy/rule path if operation is 'insert_after' or 'insert_before'
     * (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void revise(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, java.lang.String anchorPath, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SecurityPolicy> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create or Update the security policy for a domain. This is a full replace. All
     * the rules are replaced. Performance Note: If you want to edit several rules in a
     * security policy, use this API. It will perform better than several individual
     * rule APIs. Just pass all the rules which you wish to edit as embedded rules to
     * it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @return com.vmware.nsx_policy.model.SecurityPolicy
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SecurityPolicy update(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy);

    /**
     * Create or Update the security policy for a domain. This is a full replace. All
     * the rules are replaced. Performance Note: If you want to edit several rules in a
     * security policy, use this API. It will perform better than several individual
     * rule APIs. Just pass all the rules which you wish to edit as embedded rules to
     * it.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SecurityPolicy
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SecurityPolicy update(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create or Update the security policy for a domain. This is a full replace. All
     * the rules are replaced. Performance Note: If you want to edit several rules in a
     * security policy, use this API. It will perform better than several individual
     * rule APIs. Just pass all the rules which you wish to edit as embedded rules to
     * it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SecurityPolicy
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SecurityPolicy> asyncCallback);

    /**
     * Create or Update the security policy for a domain. This is a full replace. All
     * the rules are replaced. Performance Note: If you want to edit several rules in a
     * security policy, use this API. It will perform better than several individual
     * rule APIs. Just pass all the rules which you wish to edit as embedded rules to
     * it.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SecurityPolicy
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId (required)
     * @param securityPolicyId (required)
     * @param securityPolicy (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String domainId, java.lang.String securityPolicyId, com.vmware.nsx_policy.model.SecurityPolicy securityPolicy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SecurityPolicy> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
