/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.napp.common_agent.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.napp.common_agent;

public interface HostConfig extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.napp.common_agent.HostConfigTypes {

    /**
     * Get the current NSX Application Platform Common Agent host configuration.
     * Recommend to keep the value same for flow_data_collection_interval and
     * context_data_collection_interval.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo get();

    /**
     * Get the current NSX Application Platform Common Agent host configuration.
     * Recommend to keep the value same for flow_data_collection_interval and
     * context_data_collection_interval.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo get(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get the current NSX Application Platform Common Agent host configuration.
     * Recommend to keep the value same for flow_data_collection_interval and
     * context_data_collection_interval.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo> asyncCallback);

    /**
     * Get the current NSX Application Platform Common Agent host configuration.
     * Recommend to keep the value same for flow_data_collection_interval and
     * context_data_collection_interval.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Patch the current NSX Application Platform Common Agent host configuration.
     * Return error if NSX Application Platform Common Agent is not registered with
     * NSX. \"private_ip_range\" is the only field allowed to patch.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param commonAgentHostConfigurationInfo (required)
     * @return com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo patch(com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo commonAgentHostConfigurationInfo);

    /**
     * Patch the current NSX Application Platform Common Agent host configuration.
     * Return error if NSX Application Platform Common Agent is not registered with
     * NSX. \"private_ip_range\" is the only field allowed to patch.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param commonAgentHostConfigurationInfo (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo patch(com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo commonAgentHostConfigurationInfo, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Patch the current NSX Application Platform Common Agent host configuration.
     * Return error if NSX Application Platform Common Agent is not registered with
     * NSX. \"private_ip_range\" is the only field allowed to patch.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param commonAgentHostConfigurationInfo (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo commonAgentHostConfigurationInfo, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo> asyncCallback);

    /**
     * Patch the current NSX Application Platform Common Agent host configuration.
     * Return error if NSX Application Platform Common Agent is not registered with
     * NSX. \"private_ip_range\" is the only field allowed to patch.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param commonAgentHostConfigurationInfo (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo commonAgentHostConfigurationInfo, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Reset NSX Application Platform Common Agent host configuration to the default
     * setting. Clear NSX Application Platform Common Agent host configuration if NSX
     * Application Platform Common Agent is not registered with NSX. Return the NSX
     * Application Platform Common Agent host configuration after reset operation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo reset();

    /**
     * Reset NSX Application Platform Common Agent host configuration to the default
     * setting. Clear NSX Application Platform Common Agent host configuration if NSX
     * Application Platform Common Agent is not registered with NSX. Return the NSX
     * Application Platform Common Agent host configuration after reset operation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo reset(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Reset NSX Application Platform Common Agent host configuration to the default
     * setting. Clear NSX Application Platform Common Agent host configuration if NSX
     * Application Platform Common Agent is not registered with NSX. Return the NSX
     * Application Platform Common Agent host configuration after reset operation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void reset(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo> asyncCallback);

    /**
     * Reset NSX Application Platform Common Agent host configuration to the default
     * setting. Clear NSX Application Platform Common Agent host configuration if NSX
     * Application Platform Common Agent is not registered with NSX. Return the NSX
     * Application Platform Common Agent host configuration after reset operation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void reset(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.CommonAgentHostConfigurationInfo> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
