/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.lldp.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.lldp;

public interface Interfaces extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.sites.enforcement_points.host_transport_nodes.lldp.InterfacesTypes {

    /**
     * Read LLDP Neighbor Properties of transport node by Interface Name
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId site ID (required)
     * @param enforcementPointId enforcement point ID (required)
     * @param nodeId ID of transport node (required)
     * @param interfaceName Interface name to read (required)
     * @return com.vmware.nsx_policy.model.InterfaceNeighborProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.InterfaceNeighborProperties get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String nodeId, java.lang.String interfaceName);

    /**
     * Read LLDP Neighbor Properties of transport node by Interface Name
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId site ID (required)
     * @param enforcementPointId enforcement point ID (required)
     * @param nodeId ID of transport node (required)
     * @param interfaceName Interface name to read (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.InterfaceNeighborProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.InterfaceNeighborProperties get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String nodeId, java.lang.String interfaceName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read LLDP Neighbor Properties of transport node by Interface Name
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.InterfaceNeighborProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId site ID (required)
     * @param enforcementPointId enforcement point ID (required)
     * @param nodeId ID of transport node (required)
     * @param interfaceName Interface name to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String nodeId, java.lang.String interfaceName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.InterfaceNeighborProperties> asyncCallback);

    /**
     * Read LLDP Neighbor Properties of transport node by Interface Name
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.InterfaceNeighborProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId site ID (required)
     * @param enforcementPointId enforcement point ID (required)
     * @param nodeId ID of transport node (required)
     * @param interfaceName Interface name to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String nodeId, java.lang.String interfaceName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.InterfaceNeighborProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List LLDP Neighbor Properties of given Node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId site ID (required)
     * @param enforcementPointId enforcement point ID (required)
     * @param nodeId ID of transport node (required)
     * @return com.vmware.nsx_policy.model.InterfaceNeighborPropertyListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.InterfaceNeighborPropertyListResult list(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String nodeId);

    /**
     * List LLDP Neighbor Properties of given Node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId site ID (required)
     * @param enforcementPointId enforcement point ID (required)
     * @param nodeId ID of transport node (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.InterfaceNeighborPropertyListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.InterfaceNeighborPropertyListResult list(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String nodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List LLDP Neighbor Properties of given Node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.InterfaceNeighborPropertyListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId site ID (required)
     * @param enforcementPointId enforcement point ID (required)
     * @param nodeId ID of transport node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String nodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.InterfaceNeighborPropertyListResult> asyncCallback);

    /**
     * List LLDP Neighbor Properties of given Node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.InterfaceNeighborPropertyListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId site ID (required)
     * @param enforcementPointId enforcement point ID (required)
     * @param nodeId ID of transport node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String siteId, java.lang.String enforcementPointId, java.lang.String nodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.InterfaceNeighborPropertyListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
