/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.sites.napp.deployment.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.sites.napp.deployment;

public interface Platform extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.sites.napp.deployment.PlatformTypes {

    /**
     * Get input parameters required to deploy NSX Application Platform.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @return com.vmware.nsx_policy.model.PlatformDeploymentConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PlatformDeploymentConfig get(java.lang.String siteId);

    /**
     * Get input parameters required to deploy NSX Application Platform.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PlatformDeploymentConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PlatformDeploymentConfig get(java.lang.String siteId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get input parameters required to deploy NSX Application Platform.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PlatformDeploymentConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String siteId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PlatformDeploymentConfig> asyncCallback);

    /**
     * Get input parameters required to deploy NSX Application Platform.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PlatformDeploymentConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String siteId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PlatformDeploymentConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update input parameters required to deploy platform related pods. The UI has
     * option to deploy kubernetes tools. You need to get this file from VMware
     * website. File contains kubectl binary, helm binary and signature to verify them.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param platformDeploymentConfig (required)
     * @return com.vmware.nsx_policy.model.PlatformDeploymentConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PlatformDeploymentConfig patch(java.lang.String siteId, com.vmware.nsx_policy.model.PlatformDeploymentConfig platformDeploymentConfig);

    /**
     * Update input parameters required to deploy platform related pods. The UI has
     * option to deploy kubernetes tools. You need to get this file from VMware
     * website. File contains kubectl binary, helm binary and signature to verify them.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param platformDeploymentConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.PlatformDeploymentConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.PlatformDeploymentConfig patch(java.lang.String siteId, com.vmware.nsx_policy.model.PlatformDeploymentConfig platformDeploymentConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update input parameters required to deploy platform related pods. The UI has
     * option to deploy kubernetes tools. You need to get this file from VMware
     * website. File contains kubectl binary, helm binary and signature to verify them.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PlatformDeploymentConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param platformDeploymentConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String siteId, com.vmware.nsx_policy.model.PlatformDeploymentConfig platformDeploymentConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PlatformDeploymentConfig> asyncCallback);

    /**
     * Update input parameters required to deploy platform related pods. The UI has
     * option to deploy kubernetes tools. You need to get this file from VMware
     * website. File contains kubectl binary, helm binary and signature to verify them.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.PlatformDeploymentConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param platformDeploymentConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String siteId, com.vmware.nsx_policy.model.PlatformDeploymentConfig platformDeploymentConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.PlatformDeploymentConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
