/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.sites.napp.deployment.tools.upload.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.sites.napp.deployment.tools.upload;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.sites.napp.deployment.tools.upload.StatusTypes {

    /**
     * Get the progress of uploading kubernetes tools bundle from the remote location.
     * This API will also verify the kubernetes tools bundle, before marking upload as
     * a success.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param siteId (required)
     * @param bundleId (required)
     * @return com.vmware.nsx_policy.model.UploadBundleStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.UploadBundleStatus get(java.lang.String siteId, java.lang.String bundleId);

    /**
     * Get the progress of uploading kubernetes tools bundle from the remote location.
     * This API will also verify the kubernetes tools bundle, before marking upload as
     * a success.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param siteId (required)
     * @param bundleId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.UploadBundleStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.UploadBundleStatus get(java.lang.String siteId, java.lang.String bundleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get the progress of uploading kubernetes tools bundle from the remote location.
     * This API will also verify the kubernetes tools bundle, before marking upload as
     * a success.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.UploadBundleStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param bundleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String siteId, java.lang.String bundleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.UploadBundleStatus> asyncCallback);

    /**
     * Get the progress of uploading kubernetes tools bundle from the remote location.
     * This API will also verify the kubernetes tools bundle, before marking upload as
     * a success.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.UploadBundleStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param siteId (required)
     * @param bundleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String siteId, java.lang.String bundleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.UploadBundleStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
