/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_0s.ipsec_vpn_services.sessions.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_0s.ipsec_vpn_services.sessions;

public interface Statistics extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_0s.ipsec_vpn_services.sessions.StatisticsTypes {

    /**
     * Resets the statistics of the given VPN session. Since source of data is
     * enforcement point, data is reset there.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param action Action on statistics (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String tier0Id, java.lang.String serviceId, java.lang.String sessionId, java.lang.String action, java.lang.String enforcementPointPath);

    /**
     * Resets the statistics of the given VPN session. Since source of data is
     * enforcement point, data is reset there.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param action Action on statistics (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String tier0Id, java.lang.String serviceId, java.lang.String sessionId, java.lang.String action, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Resets the statistics of the given VPN session. Since source of data is
     * enforcement point, data is reset there.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param action Action on statistics (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String tier0Id, java.lang.String serviceId, java.lang.String sessionId, java.lang.String action, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Resets the statistics of the given VPN session. Since source of data is
     * enforcement point, data is reset there.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param action Action on statistics (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String tier0Id, java.lang.String serviceId, java.lang.String sessionId, java.lang.String action, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * - no enforcement point path specified: statistics are evaluated on each
     * enforcement point. - an enforcement point path is specified: statistics are
     * evaluated only on the given enforcement point. - source=realtime: statistics are
     * fetched realtime from the enforcement point. - source=cached: cached statistics
     * from enforcement point are returned. Please note that cache synchronization is
     * based on triggering this API with source=realtime or empty source and not
     * polling based.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx_policy.model.AggregateIPSecVpnSessionStatistics
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.AggregateIPSecVpnSessionStatistics get(java.lang.String tier0Id, java.lang.String serviceId, java.lang.String sessionId, java.lang.String enforcementPointPath, java.lang.String source);

    /**
     * - no enforcement point path specified: statistics are evaluated on each
     * enforcement point. - an enforcement point path is specified: statistics are
     * evaluated only on the given enforcement point. - source=realtime: statistics are
     * fetched realtime from the enforcement point. - source=cached: cached statistics
     * from enforcement point are returned. Please note that cache synchronization is
     * based on triggering this API with source=realtime or empty source and not
     * polling based.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.AggregateIPSecVpnSessionStatistics
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.AggregateIPSecVpnSessionStatistics get(java.lang.String tier0Id, java.lang.String serviceId, java.lang.String sessionId, java.lang.String enforcementPointPath, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * - no enforcement point path specified: statistics are evaluated on each
     * enforcement point. - an enforcement point path is specified: statistics are
     * evaluated only on the given enforcement point. - source=realtime: statistics are
     * fetched realtime from the enforcement point. - source=cached: cached statistics
     * from enforcement point are returned. Please note that cache synchronization is
     * based on triggering this API with source=realtime or empty source and not
     * polling based.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.AggregateIPSecVpnSessionStatistics
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier0Id, java.lang.String serviceId, java.lang.String sessionId, java.lang.String enforcementPointPath, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.AggregateIPSecVpnSessionStatistics> asyncCallback);

    /**
     * - no enforcement point path specified: statistics are evaluated on each
     * enforcement point. - an enforcement point path is specified: statistics are
     * evaluated only on the given enforcement point. - source=realtime: statistics are
     * fetched realtime from the enforcement point. - source=cached: cached statistics
     * from enforcement point are returned. Please note that cache synchronization is
     * based on triggering this API with source=realtime or empty source and not
     * polling based.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.AggregateIPSecVpnSessionStatistics
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier0Id, java.lang.String serviceId, java.lang.String sessionId, java.lang.String enforcementPointPath, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.AggregateIPSecVpnSessionStatistics> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
