/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_0s.locale_services.byod_service_instances.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_0s.locale_services.byod_service_instances;

public interface ServiceInstanceEndpoints extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_0s.locale_services.byod_service_instances.ServiceInstanceEndpointsTypes {

    /**
     * Delete service instance endpoint
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId);

    /**
     * Delete service instance endpoint
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete service instance endpoint
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete service instance endpoint
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read service instance endpoint
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @return com.vmware.nsx_policy.model.ServiceInstanceEndpoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ServiceInstanceEndpoint get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId);

    /**
     * Read service instance endpoint
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ServiceInstanceEndpoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ServiceInstanceEndpoint get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read service instance endpoint
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceInstanceEndpoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceInstanceEndpoint> asyncCallback);

    /**
     * Read service instance endpoint
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceInstanceEndpoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceInstanceEndpoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all service instance endpoint
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.ServiceInstanceEndpointListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ServiceInstanceEndpointListResult list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List all service instance endpoint
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ServiceInstanceEndpointListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ServiceInstanceEndpointListResult list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all service instance endpoint
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceInstanceEndpointListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceInstanceEndpointListResult> asyncCallback);

    /**
     * List all service instance endpoint
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceInstanceEndpointListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceInstanceEndpointListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create Service instance endpoint.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param serviceInstanceEndpoint (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.nsx_policy.model.ServiceInstanceEndpoint serviceInstanceEndpoint);

    /**
     * Create Service instance endpoint.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param serviceInstanceEndpoint (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.nsx_policy.model.ServiceInstanceEndpoint serviceInstanceEndpoint, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create Service instance endpoint.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param serviceInstanceEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.nsx_policy.model.ServiceInstanceEndpoint serviceInstanceEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create Service instance endpoint.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param serviceInstanceEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.nsx_policy.model.ServiceInstanceEndpoint serviceInstanceEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create service instance endpoint with given request if not exist. Modification
     * of service instance endpoint is not allowed.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param serviceInstanceEndpoint (required)
     * @return com.vmware.nsx_policy.model.ServiceInstanceEndpoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ServiceInstanceEndpoint update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.nsx_policy.model.ServiceInstanceEndpoint serviceInstanceEndpoint);

    /**
     * Create service instance endpoint with given request if not exist. Modification
     * of service instance endpoint is not allowed.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param serviceInstanceEndpoint (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ServiceInstanceEndpoint
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ServiceInstanceEndpoint update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.nsx_policy.model.ServiceInstanceEndpoint serviceInstanceEndpoint, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create service instance endpoint with given request if not exist. Modification
     * of service instance endpoint is not allowed.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceInstanceEndpoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param serviceInstanceEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.nsx_policy.model.ServiceInstanceEndpoint serviceInstanceEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceInstanceEndpoint> asyncCallback);

    /**
     * Create service instance endpoint with given request if not exist. Modification
     * of service instance endpoint is not allowed.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ServiceInstanceEndpoint
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 id (required)
     * @param localeServiceId Locale service id (required)
     * @param serviceInstanceId Service instance id (required)
     * @param serviceInstanceEndpointId Service instance endpoint id (required)
     * @param serviceInstanceEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String tier0Id, java.lang.String localeServiceId, java.lang.String serviceInstanceId, java.lang.String serviceInstanceEndpointId, com.vmware.nsx_policy.model.ServiceInstanceEndpoint serviceInstanceEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ServiceInstanceEndpoint> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
