/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions;

public interface PeerConfig extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.tier_1s.locale_services.l2vpn_services.sessions.PeerConfigTypes {

    /**
     * Get peer config for the Tier-1 L2VPN session to configure the remote side of the
     * tunnel. - no enforcement point path specified: L2VPN Session Peer Codes will be
     * evaluated on each enforcement point. - enforcement point paths specified: L2VPN
     * Session Peer Codes are evaluated only on the given enforcement points. API
     * supported only when L2VPN Service is in Server Mode. <br/> This API is
     * deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/
     * sessions/<session-id>/peer-config instead. Note: The API will return a new VPN
     * path for \"transport_tunnel_path\" in the response payload instead of the
     * deprecated API path Both paths refer to the same object. Please note that
     * request is validated and any error messages returned from validation may include
     * the new VPN path instead of the deprecated path. Both new path and old path
     * refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @return com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig get(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, java.lang.String enforcementPointPath);

    /**
     * Get peer config for the Tier-1 L2VPN session to configure the remote side of the
     * tunnel. - no enforcement point path specified: L2VPN Session Peer Codes will be
     * evaluated on each enforcement point. - enforcement point paths specified: L2VPN
     * Session Peer Codes are evaluated only on the given enforcement points. API
     * supported only when L2VPN Service is in Server Mode. <br/> This API is
     * deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/
     * sessions/<session-id>/peer-config instead. Note: The API will return a new VPN
     * path for \"transport_tunnel_path\" in the response payload instead of the
     * deprecated API path Both paths refer to the same object. Please note that
     * request is validated and any error messages returned from validation may include
     * the new VPN path instead of the deprecated path. Both new path and old path
     * refer to same resource.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig get(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get peer config for the Tier-1 L2VPN session to configure the remote side of the
     * tunnel. - no enforcement point path specified: L2VPN Session Peer Codes will be
     * evaluated on each enforcement point. - enforcement point paths specified: L2VPN
     * Session Peer Codes are evaluated only on the given enforcement points. API
     * supported only when L2VPN Service is in Server Mode. <br/> This API is
     * deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/
     * sessions/<session-id>/peer-config instead. Note: The API will return a new VPN
     * path for \"transport_tunnel_path\" in the response payload instead of the
     * deprecated API path Both paths refer to the same object. Please note that
     * request is validated and any error messages returned from validation may include
     * the new VPN path instead of the deprecated path. Both new path and old path
     * refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig> asyncCallback);

    /**
     * Get peer config for the Tier-1 L2VPN session to configure the remote side of the
     * tunnel. - no enforcement point path specified: L2VPN Session Peer Codes will be
     * evaluated on each enforcement point. - enforcement point paths specified: L2VPN
     * Session Peer Codes are evaluated only on the given enforcement points. API
     * supported only when L2VPN Service is in Server Mode. <br/> This API is
     * deprecated. Please use GET
     * /infra/tier-1s/<tier-1-id>/l2vpn-services/<service-id>/
     * sessions/<session-id>/peer-config instead. Note: The API will return a new VPN
     * path for \"transport_tunnel_path\" in the response payload instead of the
     * deprecated API path Both paths refer to the same object. Please note that
     * request is validated and any error messages returned from validation may include
     * the new VPN path instead of the deprecated path. Both new path and old path
     * refer to same resource.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param tier1Id (required)
     * @param localeServiceId (required)
     * @param serviceId (required)
     * @param sessionId (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String tier1Id, java.lang.String localeServiceId, java.lang.String serviceId, java.lang.String sessionId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.AggregateL2VPNSessionPeerConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
