/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * These are advanced configuration options.
 */
public final class AdvancedConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "AdvancedConfig";

    private java.util.List<com.vmware.nsx_policy.model.HighPerformanceConfigParams> highPerformanceConfigParams;

    private final java.lang.String highPerformanceConfigType = "AdvancedConfig";

    private java.util.List<java.lang.String> version;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public AdvancedConfig() {
    }

    protected AdvancedConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * List of parameters that could be used to configure high performance.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.HighPerformanceConfigParams> getHighPerformanceConfigParams() {
        return this.highPerformanceConfigParams;
    }

    /**
     * List of parameters that could be used to configure high performance.
     *
     * @param highPerformanceConfigParams New value for the property.
     */
    public void setHighPerformanceConfigParams(java.util.List<com.vmware.nsx_policy.model.HighPerformanceConfigParams> highPerformanceConfigParams) {
        this.highPerformanceConfigParams = highPerformanceConfigParams;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.HighPerformanceConfig#HIGH_PERFORMANCE_CONFIG_TYPE_ADV_CONFIG}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HighPerformanceConfig#HIGH_PERFORMANCE_CONFIG_TYPE_DRIVER_CONFIG}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.HighPerformanceConfig#HIGH_PERFORMANCE_CONFIG_TYPE_MISC_CONFIG}</li>
     * </ul> The specific type of config.
     * The value of this property is automatically populated to {@code "AdvancedConfig"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHighPerformanceConfigType() {
        return this.highPerformanceConfigType;
    }

    /**
     * Based on the high_performance_config_type, it could be either driver version or
     * host version. For high_performance_config_type as ADV_CONFIG or MISC_CONFIG,
     * this represents host version. For high_performance_config_type as DRIVER_CONFIG,
     * this represents physical NIC driver version.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getVersion() {
        return this.version;
    }

    /**
     * Based on the high_performance_config_type, it could be either driver version or
     * host version. For high_performance_config_type as ADV_CONFIG or MISC_CONFIG,
     * this represents host version. For high_performance_config_type as DRIVER_CONFIG,
     * this represents physical NIC driver version.
     *
     * @param version New value for the property.
     */
    public void setVersion(java.util.List<java.lang.String> version) {
        this.version = version;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.advancedConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("high_performance_config_params",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.highPerformanceConfigParams, this._getType().getField("high_performance_config_params")));
        structValue.setField("high_performance_config_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.highPerformanceConfigType, this._getType().getField("high_performance_config_type")));
        structValue.setField("version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.version, this._getType().getField("version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.advancedConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.advancedConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static AdvancedConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new AdvancedConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static AdvancedConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new AdvancedConfig(structValue);
    }

    /**
     * Builder class for {@link AdvancedConfig}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.HighPerformanceConfigParams> highPerformanceConfigParams;
        private java.util.List<java.lang.String> version;

        /**
         * Constructor with parameters for the required properties of
         * {@link AdvancedConfig}.
         */
        public Builder() {
        }

        /**
         * List of parameters that could be used to configure high performance.
         *
         * @param highPerformanceConfigParams New value for the property.
         */
        public Builder setHighPerformanceConfigParams(java.util.List<com.vmware.nsx_policy.model.HighPerformanceConfigParams> highPerformanceConfigParams) {
            this.highPerformanceConfigParams = highPerformanceConfigParams;
            return this;
        }

        /**
         * Based on the high_performance_config_type, it could be either driver version or
         * host version. For high_performance_config_type as ADV_CONFIG or MISC_CONFIG,
         * this represents host version. For high_performance_config_type as DRIVER_CONFIG,
         * this represents physical NIC driver version.
         *
         * @param version New value for the property.
         */
        public Builder setVersion(java.util.List<java.lang.String> version) {
            this.version = version;
            return this;
        }

        public AdvancedConfig build() {
            AdvancedConfig result = new AdvancedConfig();
            result.setHighPerformanceConfigParams(this.highPerformanceConfigParams);
            result.setVersion(this.version);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("high_performance_config_params", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.highPerformanceConfigParams; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("high_performance_config_params",
                                                                                "highPerformanceConfigParams",
                                                                                "getHighPerformanceConfigParams",
                                                                                "setHighPerformanceConfigParams");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("high_performance_config_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("high_performance_config_type",
                                                                                "highPerformanceConfigType",
                                                                                "getHighPerformanceConfigType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("version",
                                                                                "version",
                                                                                "getVersion",
                                                                                "setVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.advanced_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.AdvancedConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "high_performance_config_type",
                                                            "AdvancedConfig");
    }
}

