/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Bfd Health Monitoring Options used specific to BFD Transport Zone profiles
 */
public final class BfdHealthMonitoringConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean enabled;

    private java.lang.Boolean latencyEnabled;

    private java.lang.Long probeInterval;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public BfdHealthMonitoringConfig() {
    }

    protected BfdHealthMonitoringConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Whether the heartbeat is enabled. A PATCH or PUT request with \"enabled\" false
     * (with no probe intervals) will set or reset the probe_interval to their default
     * value.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Whether the heartbeat is enabled. A PATCH or PUT request with \"enabled\" false
     * (with no probe intervals) will set or reset the probe_interval to their default
     * value.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * The flag is to turn on/off latency. A PATCH or PUT request with
     * \"latency_enabled\" true will enable NSX to send the networking latency data to
     * thrid-party monitoring tools like vRNI.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getLatencyEnabled() {
        return this.latencyEnabled;
    }

    /**
     * The flag is to turn on/off latency. A PATCH or PUT request with
     * \"latency_enabled\" true will enable NSX to send the networking latency data to
     * thrid-party monitoring tools like vRNI.
     *
     * @param latencyEnabled New value for the property.
     */
    public void setLatencyEnabled(java.lang.Boolean latencyEnabled) {
        this.latencyEnabled = latencyEnabled;
    }

    /**
     * The time interval (in millisec) between probe packets for tunnels between
     * transport nodes. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getProbeInterval() {
        return this.probeInterval;
    }

    /**
     * The time interval (in millisec) between probe packets for tunnels between
     * transport nodes. format: int64
     *
     * @param probeInterval New value for the property.
     */
    public void setProbeInterval(java.lang.Long probeInterval) {
        this.probeInterval = probeInterval;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.bfdHealthMonitoringConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("latency_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.latencyEnabled, this._getType().getField("latency_enabled")));
        structValue.setField("probe_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.probeInterval, this._getType().getField("probe_interval")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.bfdHealthMonitoringConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.bfdHealthMonitoringConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static BfdHealthMonitoringConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new BfdHealthMonitoringConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static BfdHealthMonitoringConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new BfdHealthMonitoringConfig(structValue);
    }

    /**
     * Builder class for {@link BfdHealthMonitoringConfig}.
     */
    public static final class Builder {
        private java.lang.Boolean enabled;
        private java.lang.Boolean latencyEnabled;
        private java.lang.Long probeInterval;

        /**
         * Constructor with parameters for the required properties of
         * {@link BfdHealthMonitoringConfig}.
         */
        public Builder() {
        }

        /**
         * Whether the heartbeat is enabled. A PATCH or PUT request with \"enabled\" false
         * (with no probe intervals) will set or reset the probe_interval to their default
         * value.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * The flag is to turn on/off latency. A PATCH or PUT request with
         * \"latency_enabled\" true will enable NSX to send the networking latency data to
         * thrid-party monitoring tools like vRNI.
         *
         * @param latencyEnabled New value for the property.
         */
        public Builder setLatencyEnabled(java.lang.Boolean latencyEnabled) {
            this.latencyEnabled = latencyEnabled;
            return this;
        }

        /**
         * The time interval (in millisec) between probe packets for tunnels between
         * transport nodes. format: int64
         *
         * @param probeInterval New value for the property.
         */
        public Builder setProbeInterval(java.lang.Long probeInterval) {
            this.probeInterval = probeInterval;
            return this;
        }

        public BfdHealthMonitoringConfig build() {
            BfdHealthMonitoringConfig result = new BfdHealthMonitoringConfig();
            result.setEnabled(this.enabled);
            result.setLatencyEnabled(this.latencyEnabled);
            result.setProbeInterval(this.probeInterval);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("latency_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("latency_enabled",
                                                                                "latencyEnabled",
                                                                                "getLatencyEnabled",
                                                                                "setLatencyEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("probe_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("probe_interval",
                                                                                "probeInterval",
                                                                                "getProbeInterval",
                                                                                "setProbeInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.bfd_health_monitoring_config",
                                                            fields,
                                                            com.vmware.nsx_policy.model.BfdHealthMonitoringConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

