/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Represents the leaf level expression to restrict the target attribute value
 * based on the set of existing values. Generally, used in combination with
 * RelatedAttributeConditionalExpression to constraint the values related to
 * another attribute on the same resource. This object is always used in
 * conjunction with some exression. Example - { \"condition\" : {
 * \"operator\":\"INCLUDES\", \"rhs_value\":
 * [\"/infra/domains/mgw/groups/VCENTER\", \"/infra/domains/mgw/groups/SRM\",
 * \"/infra/domains/mgw/groups/NSX\"], \"value_constraint\": { \"resource_type\":
 * \"ValueConstraintExpression\", \"operator\":\"EXCLUDES\",
 * \"values\":[\"/infra/domains/mgw/groups/VCENTER\",
 * \"/infra/domains/mgw/groups/SRM\", \"/infra/domains/mgw/groups/NSX\"] } }
 */
public final class ConditionalValueConstraintExpression implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String OPERATOR_INCLUDES = "INCLUDES";

    public static final java.lang.String OPERATOR_INCLUDES_ANY = "INCLUDES_ANY";

    public static final java.lang.String OPERATOR_EXCLUDES = "EXCLUDES";

    public static final java.lang.String OPERATOR_EQUALS = "EQUALS";

    private java.lang.String operator;

    private java.util.List<java.lang.String> rhsValue;

    private com.vmware.vapi.bindings.Structure rhsValueWithType;

    private com.vmware.nsx_policy.model.ValueConstraintExpression valueConstraint;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ConditionalValueConstraintExpression() {
    }

    protected ConditionalValueConstraintExpression(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_INCLUDES}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_INCLUDES_ANY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_EXCLUDES}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_EQUALS}</li>
     * </ul> INCLUDES_ANY operator supported only for StringArrayConstraintValue
     *
     * @return The current value of the property.
     */
    public java.lang.String getOperator() {
        return this.operator;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_INCLUDES}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_INCLUDES_ANY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_EXCLUDES}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_EQUALS}</li>
     * </ul> INCLUDES_ANY operator supported only for StringArrayConstraintValue
     *
     * @param operator New value for the property.
     */
    public void setOperator(java.lang.String operator) {
        this.operator = operator;
    }

    /**
     * List of values.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getRhsValue() {
        return this.rhsValue;
    }

    /**
     * List of values.
     *
     * @param rhsValue New value for the property.
     */
    public void setRhsValue(java.util.List<java.lang.String> rhsValue) {
        this.rhsValue = rhsValue;
    }

    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ConstraintValue}. When methods return a value of
     * this class as a return value, the property will contain all the properties
     * defined in {@link com.vmware.nsx_policy.model.ConstraintValue}.
     */
    public com.vmware.vapi.bindings.Structure getRhsValueWithType() {
        return this.rhsValueWithType;
    }

    /**
     *
     *
     * @param rhsValueWithType New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ConstraintValue}. When methods return a value of
     * this class as a return value, the property will contain all the properties
     * defined in {@link com.vmware.nsx_policy.model.ConstraintValue}.
     */
    public void setRhsValueWithType(com.vmware.vapi.bindings.Structure rhsValueWithType) {
        this.rhsValueWithType = rhsValueWithType;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.ValueConstraintExpression getValueConstraint() {
        return this.valueConstraint;
    }

    /**
     *
     *
     * @param valueConstraint New value for the property.
     */
    public void setValueConstraint(com.vmware.nsx_policy.model.ValueConstraintExpression valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.conditionalValueConstraintExpression;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("operator",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.operator, this._getType().getField("operator")));
        structValue.setField("rhs_value",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rhsValue, this._getType().getField("rhs_value")));
        structValue.setField("rhs_value_with_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rhsValueWithType, this._getType().getField("rhs_value_with_type")));
        structValue.setField("value_constraint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.valueConstraint, this._getType().getField("value_constraint")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.conditionalValueConstraintExpression;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.conditionalValueConstraintExpression.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ConditionalValueConstraintExpression _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ConditionalValueConstraintExpression(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ConditionalValueConstraintExpression _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ConditionalValueConstraintExpression(structValue);
    }

    /**
     * Builder class for {@link ConditionalValueConstraintExpression}.
     */
    public static final class Builder {
        private java.lang.String operator;
        private java.util.List<java.lang.String> rhsValue;
        private com.vmware.vapi.bindings.Structure rhsValueWithType;
        private com.vmware.nsx_policy.model.ValueConstraintExpression valueConstraint;

        /**
         * Constructor with parameters for the required properties of
         * {@link ConditionalValueConstraintExpression}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_INCLUDES}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_INCLUDES_ANY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_EXCLUDES}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.ConditionalValueConstraintExpression#OPERATOR_EQUALS}</li>
         * </ul> INCLUDES_ANY operator supported only for StringArrayConstraintValue
         *
         * @param operator New value for the property.
         */
        public Builder setOperator(java.lang.String operator) {
            this.operator = operator;
            return this;
        }

        /**
         * List of values.
         *
         * @param rhsValue New value for the property.
         */
        public Builder setRhsValue(java.util.List<java.lang.String> rhsValue) {
            this.rhsValue = rhsValue;
            return this;
        }

        /**
         *
         *
         * @param rhsValueWithType New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.ConstraintValue}. When methods return a value of
         * this class as a return value, the property will contain all the properties
         * defined in {@link com.vmware.nsx_policy.model.ConstraintValue}.
         */
        public Builder setRhsValueWithType(com.vmware.vapi.bindings.Structure rhsValueWithType) {
            this.rhsValueWithType = rhsValueWithType;
            return this;
        }

        /**
         *
         *
         * @param valueConstraint New value for the property.
         */
        public Builder setValueConstraint(com.vmware.nsx_policy.model.ValueConstraintExpression valueConstraint) {
            this.valueConstraint = valueConstraint;
            return this;
        }

        public ConditionalValueConstraintExpression build() {
            ConditionalValueConstraintExpression result = new ConditionalValueConstraintExpression();
            result.setOperator(this.operator);
            result.setRhsValue(this.rhsValue);
            result.setRhsValueWithType(this.rhsValueWithType);
            result.setValueConstraint(this.valueConstraint);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("operator", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("operator",
                                                                                "operator",
                                                                                "getOperator",
                                                                                "setOperator");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rhs_value", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rhs_value",
                                                                                "rhsValue",
                                                                                "getRhsValue",
                                                                                "setRhsValue");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rhs_value_with_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.constraintValue; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rhs_value_with_type",
                                                                                "rhsValueWithType",
                                                                                "getRhsValueWithType",
                                                                                "setRhsValueWithType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("value_constraint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.valueConstraintExpression; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("value_constraint",
                                                                                "valueConstraint",
                                                                                "getValueConstraint",
                                                                                "setValueConstraint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.conditional_value_constraint_expression",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ConditionalValueConstraintExpression.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

