/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * This holds the request parameters required to invoke export task.
 */
public final class ExportRequestParameter implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String draftPath;

    private java.lang.String passphrase;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ExportRequestParameter() {
    }

    protected ExportRequestParameter(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Policy path of a draft which is to be exported. If not provided, current
     * firewall configuration will then be exported.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDraftPath() {
        return this.draftPath;
    }

    /**
     * Policy path of a draft which is to be exported. If not provided, current
     * firewall configuration will then be exported.
     *
     * @param draftPath New value for the property.
     */
    public void setDraftPath(java.lang.String draftPath) {
        this.draftPath = draftPath;
    }

    /**
     * Passphrase to sign exported files. The passphrase specified must be at least 8
     * characters in length and must contain at least one lowercase, one uppercase, one
     * numeric character and one non-space special character.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPassphrase() {
        return this.passphrase;
    }

    /**
     * Passphrase to sign exported files. The passphrase specified must be at least 8
     * characters in length and must contain at least one lowercase, one uppercase, one
     * numeric character and one non-space special character.
     *
     * @param passphrase New value for the property.
     */
    public void setPassphrase(java.lang.String passphrase) {
        this.passphrase = passphrase;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.exportRequestParameter;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("draft_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.draftPath, this._getType().getField("draft_path")));
        structValue.setField("passphrase",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.passphrase, this._getType().getField("passphrase")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.exportRequestParameter;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.exportRequestParameter.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ExportRequestParameter _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ExportRequestParameter(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ExportRequestParameter _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ExportRequestParameter(structValue);
    }

    /**
     * Builder class for {@link ExportRequestParameter}.
     */
    public static final class Builder {
        private java.lang.String draftPath;
        private java.lang.String passphrase;

        /**
         * Constructor with parameters for the required properties of
         * {@link ExportRequestParameter}.
         */
        public Builder() {
        }

        /**
         * Policy path of a draft which is to be exported. If not provided, current
         * firewall configuration will then be exported.
         *
         * @param draftPath New value for the property.
         */
        public Builder setDraftPath(java.lang.String draftPath) {
            this.draftPath = draftPath;
            return this;
        }

        /**
         * Passphrase to sign exported files. The passphrase specified must be at least 8
         * characters in length and must contain at least one lowercase, one uppercase, one
         * numeric character and one non-space special character.
         *
         * @param passphrase New value for the property.
         */
        public Builder setPassphrase(java.lang.String passphrase) {
            this.passphrase = passphrase;
            return this;
        }

        public ExportRequestParameter build() {
            ExportRequestParameter result = new ExportRequestParameter();
            result.setDraftPath(this.draftPath);
            result.setPassphrase(this.passphrase);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("draft_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("draft_path",
                                                                                "draftPath",
                                                                                "getDraftPath",
                                                                                "setDraftPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("passphrase", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("passphrase",
                                                                                "passphrase",
                                                                                "getPassphrase",
                                                                                "setPassphrase");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.export_request_parameter",
                                                            fields,
                                                            com.vmware.nsx_policy.model.ExportRequestParameter.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

