/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Represents details of the last full sync if full sync is not running, otherwise
 * returns the status of current full sync.
 */
public final class FullSyncInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String REASON_CODE_QUEUE_OVERFLOW_ON_TRANSMITTER = "QUEUE_OVERFLOW_ON_TRANSMITTER";

    public static final java.lang.String REASON_CODE_QUEUE_OVERFLOW_ON_RECEIVER = "QUEUE_OVERFLOW_ON_RECEIVER";

    public static final java.lang.String REASON_CODE_CONNECTION_RESTORED = "CONNECTION_RESTORED";

    public static final java.lang.String REASON_CODE_LM_ONBOARDED = "LM_ONBOARDED";

    public static final java.lang.String REASON_CODE_GM_SWITCHOVER = "GM_SWITCHOVER";

    public static final java.lang.String REASON_CODE_RESTORED_GM_FROM_BACKUP = "RESTORED_GM_FROM_BACKUP";

    public static final java.lang.String REASON_CODE_RESTORED_LM_FROM_BACKUP = "RESTORED_LM_FROM_BACKUP";

    public static final java.lang.String REASON_CODE_BROWNFIELD_CONFIG_MIGRATION_FROM_LM_TO_GM = "BROWNFIELD_CONFIG_MIGRATION_FROM_LM_TO_GM";

    public static final java.lang.String REASON_CODE_GM_REQUESTED_OVERSIZED_PAYLOAD = "GM_REQUESTED_OVERSIZED_PAYLOAD";

    public static final java.lang.String REASON_CODE_GM_REQUESTED_SITE_ONBOARDING = "GM_REQUESTED_SITE_ONBOARDING";

    public static final java.lang.String REASON_CODE_GM_REQUESTED_OTHER = "GM_REQUESTED_OTHER";

    public static final java.lang.String REASON_CODE_LM_REQUSTED_OVERSIZED_PAYLOAD = "LM_REQUSTED_OVERSIZED_PAYLOAD";

    public static final java.lang.String REASON_CODE_LM_REQUESTED_OTHER = "LM_REQUESTED_OTHER";

    public static final java.lang.String REASON_CODE_USER_REQUSTED = "USER_REQUSTED";

    public static final java.lang.String REASON_CODE_OTHER_AR_INTERNAL = "OTHER_AR_INTERNAL";

    public static final java.lang.String REASON_CODE_POST_UPGRADE_GM = "POST_UPGRADE_GM";

    public static final java.lang.String REASON_CODE_POST_UPGRADE_LM = "POST_UPGRADE_LM";

    public static final java.lang.String REASON_CODE_UNKNOWN = "UNKNOWN";

    public static final java.lang.String STAGE_NOT_STARTED = "NOT_STARTED";

    public static final java.lang.String STAGE_REQUESTED_FULL_STATE_FROM_SOURCE = "REQUESTED_FULL_STATE_FROM_SOURCE";

    public static final java.lang.String STAGE_TRANSFERRING_FULL_STATE = "TRANSFERRING_FULL_STATE";

    public static final java.lang.String STAGE_COMPLETED_TRANSFERRING_FULL_STATE = "COMPLETED_TRANSFERRING_FULL_STATE";

    public static final java.lang.String STAGE_DESTINATION_APPLYING_FULL_STATE = "DESTINATION_APPLYING_FULL_STATE";

    public static final java.lang.String STAGE_COMPLETED_SUCCESSFUL = "COMPLETED_SUCCESSFUL";

    public static final java.lang.String STAGE_TIMEOUT_ON_SOURCE_RECEIVE_FULL_STATE = "TIMEOUT_ON_SOURCE_RECEIVE_FULL_STATE";

    public static final java.lang.String STAGE_TIMEOUT_ON_DESTINATION_APPLY = "TIMEOUT_ON_DESTINATION_APPLY";

    public static final java.lang.String STAGE_COMPLETED_FAILED = "COMPLETED_FAILED";

    public static final java.lang.String STATUS_NOT_STARTED = "NOT_STARTED";

    public static final java.lang.String STATUS_IN_PROGRESS = "IN_PROGRESS";

    public static final java.lang.String STATUS_COMPLETED = "COMPLETED";

    private java.lang.Long dataStreamingFromSourceEndTime;

    private java.lang.String dataStreamingFromSourceProgress;

    private java.lang.Long dataStreamingFromSourceStartTime;

    private java.lang.Long endTime;

    private java.util.List<java.lang.String> errors;

    private java.lang.String fullSyncId;

    private java.lang.String reason;

    private java.lang.String reasonCode;

    private java.lang.Long receiverEndTime;

    private java.lang.Long receiverStartTime;

    private java.lang.String receiverState;

    private java.lang.Long receiverTimeToApplyInMillis;

    private java.lang.String stage;

    private java.lang.Long startTime;

    private java.lang.String status;

    private java.util.List<java.lang.String> warnings;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public FullSyncInfo() {
    }

    protected FullSyncInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * End time of streaming full state from source format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDataStreamingFromSourceEndTime() {
        return this.dataStreamingFromSourceEndTime;
    }

    /**
     * End time of streaming full state from source format: int64
     *
     * @param dataStreamingFromSourceEndTime New value for the property.
     */
    public void setDataStreamingFromSourceEndTime(java.lang.Long dataStreamingFromSourceEndTime) {
        this.dataStreamingFromSourceEndTime = dataStreamingFromSourceEndTime;
    }

    /**
     * Details about full sync on sender side
     *
     * @return The current value of the property.
     */
    public java.lang.String getDataStreamingFromSourceProgress() {
        return this.dataStreamingFromSourceProgress;
    }

    /**
     * Details about full sync on sender side
     *
     * @param dataStreamingFromSourceProgress New value for the property.
     */
    public void setDataStreamingFromSourceProgress(java.lang.String dataStreamingFromSourceProgress) {
        this.dataStreamingFromSourceProgress = dataStreamingFromSourceProgress;
    }

    /**
     * Start time of streaming full state from source format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDataStreamingFromSourceStartTime() {
        return this.dataStreamingFromSourceStartTime;
    }

    /**
     * Start time of streaming full state from source format: int64
     *
     * @param dataStreamingFromSourceStartTime New value for the property.
     */
    public void setDataStreamingFromSourceStartTime(java.lang.Long dataStreamingFromSourceStartTime) {
        this.dataStreamingFromSourceStartTime = dataStreamingFromSourceStartTime;
    }

    /**
     * Full sync end time format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEndTime() {
        return this.endTime;
    }

    /**
     * Full sync end time format: int64
     *
     * @param endTime New value for the property.
     */
    public void setEndTime(java.lang.Long endTime) {
        this.endTime = endTime;
    }

    /**
     * Errors if any
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getErrors() {
        return this.errors;
    }

    /**
     * Errors if any
     *
     * @param errors New value for the property.
     */
    public void setErrors(java.util.List<java.lang.String> errors) {
        this.errors = errors;
    }

    /**
     * Full sync id
     *
     * @return The current value of the property.
     */
    public java.lang.String getFullSyncId() {
        return this.fullSyncId;
    }

    /**
     * Full sync id
     *
     * @param fullSyncId New value for the property.
     */
    public void setFullSyncId(java.lang.String fullSyncId) {
        this.fullSyncId = fullSyncId;
    }

    /**
     * Description of full sync reason
     *
     * @return The current value of the property.
     */
    public java.lang.String getReason() {
        return this.reason;
    }

    /**
     * Description of full sync reason
     *
     * @param reason New value for the property.
     */
    public void setReason(java.lang.String reason) {
        this.reason = reason;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_QUEUE_OVERFLOW_ON_TRANSMITTER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_QUEUE_OVERFLOW_ON_RECEIVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_CONNECTION_RESTORED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_ONBOARDED}</li> <li>
     * {@link com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_SWITCHOVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_RESTORED_GM_FROM_BACKUP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_RESTORED_LM_FROM_BACKUP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_BROWNFIELD_CONFIG_MIGRATION_FROM_LM_TO_GM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_OVERSIZED_PAYLOAD}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_SITE_ONBOARDING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_OTHER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_REQUSTED_OVERSIZED_PAYLOAD}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_REQUESTED_OTHER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_USER_REQUSTED}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_OTHER_AR_INTERNAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_POST_UPGRADE_GM}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_POST_UPGRADE_LM}</li> <li>
     * {@link com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_UNKNOWN}</li> </ul>
     * Full sync can happen for various internal reasons, as well user can request for
     * one. The code provides the classification of possible reasons to start a full
     * sync.
     *
     * @return The current value of the property.
     */
    public java.lang.String getReasonCode() {
        return this.reasonCode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_QUEUE_OVERFLOW_ON_TRANSMITTER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_QUEUE_OVERFLOW_ON_RECEIVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_CONNECTION_RESTORED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_ONBOARDED}</li> <li>
     * {@link com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_SWITCHOVER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_RESTORED_GM_FROM_BACKUP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_RESTORED_LM_FROM_BACKUP}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_BROWNFIELD_CONFIG_MIGRATION_FROM_LM_TO_GM}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_OVERSIZED_PAYLOAD}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_SITE_ONBOARDING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_OTHER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_REQUSTED_OVERSIZED_PAYLOAD}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_REQUESTED_OTHER}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_USER_REQUSTED}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_OTHER_AR_INTERNAL}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_POST_UPGRADE_GM}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_POST_UPGRADE_LM}</li> <li>
     * {@link com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_UNKNOWN}</li> </ul>
     * Full sync can happen for various internal reasons, as well user can request for
     * one. The code provides the classification of possible reasons to start a full
     * sync.
     *
     * @param reasonCode New value for the property.
     */
    public void setReasonCode(java.lang.String reasonCode) {
        this.reasonCode = reasonCode;
    }

    /**
     * End time of completing applying full state on receiver side format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReceiverEndTime() {
        return this.receiverEndTime;
    }

    /**
     * End time of completing applying full state on receiver side format: int64
     *
     * @param receiverEndTime New value for the property.
     */
    public void setReceiverEndTime(java.lang.Long receiverEndTime) {
        this.receiverEndTime = receiverEndTime;
    }

    /**
     * Start time of applying full state on receiver side format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReceiverStartTime() {
        return this.receiverStartTime;
    }

    /**
     * Start time of applying full state on receiver side format: int64
     *
     * @param receiverStartTime New value for the property.
     */
    public void setReceiverStartTime(java.lang.Long receiverStartTime) {
        this.receiverStartTime = receiverStartTime;
    }

    /**
     * This is optional information, provides useful insights on receiver side once
     * async channel hands over full state data to receiver.
     *
     * @return The current value of the property.
     */
    public java.lang.String getReceiverState() {
        return this.receiverState;
    }

    /**
     * This is optional information, provides useful insights on receiver side once
     * async channel hands over full state data to receiver.
     *
     * @param receiverState New value for the property.
     */
    public void setReceiverState(java.lang.String receiverState) {
        this.receiverState = receiverState;
    }

    /**
     * Time taken by application receiver to apply the full state received format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReceiverTimeToApplyInMillis() {
        return this.receiverTimeToApplyInMillis;
    }

    /**
     * Time taken by application receiver to apply the full state received format:
     * int64
     *
     * @param receiverTimeToApplyInMillis New value for the property.
     */
    public void setReceiverTimeToApplyInMillis(java.lang.Long receiverTimeToApplyInMillis) {
        this.receiverTimeToApplyInMillis = receiverTimeToApplyInMillis;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_NOT_STARTED}</li> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_REQUESTED_FULL_STATE_FROM_SOURCE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TRANSFERRING_FULL_STATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_TRANSFERRING_FULL_STATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_DESTINATION_APPLYING_FULL_STATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_SUCCESSFUL}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TIMEOUT_ON_SOURCE_RECEIVE_FULL_STATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TIMEOUT_ON_DESTINATION_APPLY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_FAILED}</li> </ul> This
     * provides the insights into current full sync stage if in progress.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStage() {
        return this.stage;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_NOT_STARTED}</li> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_REQUESTED_FULL_STATE_FROM_SOURCE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TRANSFERRING_FULL_STATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_TRANSFERRING_FULL_STATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_DESTINATION_APPLYING_FULL_STATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_SUCCESSFUL}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TIMEOUT_ON_SOURCE_RECEIVE_FULL_STATE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TIMEOUT_ON_DESTINATION_APPLY}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_FAILED}</li> </ul> This
     * provides the insights into current full sync stage if in progress.
     *
     * @param stage New value for the property.
     */
    public void setStage(java.lang.String stage) {
        this.stage = stage;
    }

    /**
     * Full sync start time format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getStartTime() {
        return this.startTime;
    }

    /**
     * Full sync start time format: int64
     *
     * @param startTime New value for the property.
     */
    public void setStartTime(java.lang.Long startTime) {
        this.startTime = startTime;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_NOT_STARTED}</li> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_IN_PROGRESS}</li> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_COMPLETED}</li> </ul> Full sync
     * status
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatus() {
        return this.status;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_NOT_STARTED}</li> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_IN_PROGRESS}</li> <li> {@link
     * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_COMPLETED}</li> </ul> Full sync
     * status
     *
     * @param status New value for the property.
     */
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * Errors if any
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getWarnings() {
        return this.warnings;
    }

    /**
     * Errors if any
     *
     * @param warnings New value for the property.
     */
    public void setWarnings(java.util.List<java.lang.String> warnings) {
        this.warnings = warnings;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.fullSyncInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("data_streaming_from_source_end_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dataStreamingFromSourceEndTime, this._getType().getField("data_streaming_from_source_end_time")));
        structValue.setField("data_streaming_from_source_progress",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dataStreamingFromSourceProgress, this._getType().getField("data_streaming_from_source_progress")));
        structValue.setField("data_streaming_from_source_start_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dataStreamingFromSourceStartTime, this._getType().getField("data_streaming_from_source_start_time")));
        structValue.setField("end_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.endTime, this._getType().getField("end_time")));
        structValue.setField("errors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errors, this._getType().getField("errors")));
        structValue.setField("fullSyncId",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.fullSyncId, this._getType().getField("fullSyncId")));
        structValue.setField("reason",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reason, this._getType().getField("reason")));
        structValue.setField("reason_code",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reasonCode, this._getType().getField("reason_code")));
        structValue.setField("receiver_end_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.receiverEndTime, this._getType().getField("receiver_end_time")));
        structValue.setField("receiver_start_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.receiverStartTime, this._getType().getField("receiver_start_time")));
        structValue.setField("receiver_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.receiverState, this._getType().getField("receiver_state")));
        structValue.setField("receiver_time_to_apply_in_millis",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.receiverTimeToApplyInMillis, this._getType().getField("receiver_time_to_apply_in_millis")));
        structValue.setField("stage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.stage, this._getType().getField("stage")));
        structValue.setField("start_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.startTime, this._getType().getField("start_time")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
        structValue.setField("warnings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.warnings, this._getType().getField("warnings")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.fullSyncInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.fullSyncInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static FullSyncInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new FullSyncInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static FullSyncInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new FullSyncInfo(structValue);
    }

    /**
     * Builder class for {@link FullSyncInfo}.
     */
    public static final class Builder {
        private java.lang.Long dataStreamingFromSourceEndTime;
        private java.lang.String dataStreamingFromSourceProgress;
        private java.lang.Long dataStreamingFromSourceStartTime;
        private java.lang.Long endTime;
        private java.util.List<java.lang.String> errors;
        private java.lang.String fullSyncId;
        private java.lang.String reason;
        private java.lang.String reasonCode;
        private java.lang.Long receiverEndTime;
        private java.lang.Long receiverStartTime;
        private java.lang.String receiverState;
        private java.lang.Long receiverTimeToApplyInMillis;
        private java.lang.String stage;
        private java.lang.Long startTime;
        private java.lang.String status;
        private java.util.List<java.lang.String> warnings;

        /**
         * Constructor with parameters for the required properties of
         * {@link FullSyncInfo}.
         */
        public Builder() {
        }

        /**
         * End time of streaming full state from source format: int64
         *
         * @param dataStreamingFromSourceEndTime New value for the property.
         */
        public Builder setDataStreamingFromSourceEndTime(java.lang.Long dataStreamingFromSourceEndTime) {
            this.dataStreamingFromSourceEndTime = dataStreamingFromSourceEndTime;
            return this;
        }

        /**
         * Details about full sync on sender side
         *
         * @param dataStreamingFromSourceProgress New value for the property.
         */
        public Builder setDataStreamingFromSourceProgress(java.lang.String dataStreamingFromSourceProgress) {
            this.dataStreamingFromSourceProgress = dataStreamingFromSourceProgress;
            return this;
        }

        /**
         * Start time of streaming full state from source format: int64
         *
         * @param dataStreamingFromSourceStartTime New value for the property.
         */
        public Builder setDataStreamingFromSourceStartTime(java.lang.Long dataStreamingFromSourceStartTime) {
            this.dataStreamingFromSourceStartTime = dataStreamingFromSourceStartTime;
            return this;
        }

        /**
         * Full sync end time format: int64
         *
         * @param endTime New value for the property.
         */
        public Builder setEndTime(java.lang.Long endTime) {
            this.endTime = endTime;
            return this;
        }

        /**
         * Errors if any
         *
         * @param errors New value for the property.
         */
        public Builder setErrors(java.util.List<java.lang.String> errors) {
            this.errors = errors;
            return this;
        }

        /**
         * Full sync id
         *
         * @param fullSyncId New value for the property.
         */
        public Builder setFullSyncId(java.lang.String fullSyncId) {
            this.fullSyncId = fullSyncId;
            return this;
        }

        /**
         * Description of full sync reason
         *
         * @param reason New value for the property.
         */
        public Builder setReason(java.lang.String reason) {
            this.reason = reason;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_QUEUE_OVERFLOW_ON_TRANSMITTER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_QUEUE_OVERFLOW_ON_RECEIVER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_CONNECTION_RESTORED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_ONBOARDED}</li> <li>
         * {@link com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_SWITCHOVER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_RESTORED_GM_FROM_BACKUP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_RESTORED_LM_FROM_BACKUP}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_BROWNFIELD_CONFIG_MIGRATION_FROM_LM_TO_GM}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_OVERSIZED_PAYLOAD}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_SITE_ONBOARDING}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_GM_REQUESTED_OTHER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_REQUSTED_OVERSIZED_PAYLOAD}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_LM_REQUESTED_OTHER}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_USER_REQUSTED}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_OTHER_AR_INTERNAL}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_POST_UPGRADE_GM}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_POST_UPGRADE_LM}</li> <li>
         * {@link com.vmware.nsx_policy.model.FullSyncInfo#REASON_CODE_UNKNOWN}</li> </ul>
         * Full sync can happen for various internal reasons, as well user can request for
         * one. The code provides the classification of possible reasons to start a full
         * sync.
         *
         * @param reasonCode New value for the property.
         */
        public Builder setReasonCode(java.lang.String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        /**
         * End time of completing applying full state on receiver side format: int64
         *
         * @param receiverEndTime New value for the property.
         */
        public Builder setReceiverEndTime(java.lang.Long receiverEndTime) {
            this.receiverEndTime = receiverEndTime;
            return this;
        }

        /**
         * Start time of applying full state on receiver side format: int64
         *
         * @param receiverStartTime New value for the property.
         */
        public Builder setReceiverStartTime(java.lang.Long receiverStartTime) {
            this.receiverStartTime = receiverStartTime;
            return this;
        }

        /**
         * This is optional information, provides useful insights on receiver side once
         * async channel hands over full state data to receiver.
         *
         * @param receiverState New value for the property.
         */
        public Builder setReceiverState(java.lang.String receiverState) {
            this.receiverState = receiverState;
            return this;
        }

        /**
         * Time taken by application receiver to apply the full state received format:
         * int64
         *
         * @param receiverTimeToApplyInMillis New value for the property.
         */
        public Builder setReceiverTimeToApplyInMillis(java.lang.Long receiverTimeToApplyInMillis) {
            this.receiverTimeToApplyInMillis = receiverTimeToApplyInMillis;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_NOT_STARTED}</li> <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_REQUESTED_FULL_STATE_FROM_SOURCE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TRANSFERRING_FULL_STATE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_TRANSFERRING_FULL_STATE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_DESTINATION_APPLYING_FULL_STATE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_SUCCESSFUL}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TIMEOUT_ON_SOURCE_RECEIVE_FULL_STATE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_TIMEOUT_ON_DESTINATION_APPLY}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STAGE_COMPLETED_FAILED}</li> </ul> This
         * provides the insights into current full sync stage if in progress.
         *
         * @param stage New value for the property.
         */
        public Builder setStage(java.lang.String stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Full sync start time format: int64
         *
         * @param startTime New value for the property.
         */
        public Builder setStartTime(java.lang.Long startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_NOT_STARTED}</li> <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_IN_PROGRESS}</li> <li> {@link
         * com.vmware.nsx_policy.model.FullSyncInfo#STATUS_COMPLETED}</li> </ul> Full sync
         * status
         *
         * @param status New value for the property.
         */
        public Builder setStatus(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Errors if any
         *
         * @param warnings New value for the property.
         */
        public Builder setWarnings(java.util.List<java.lang.String> warnings) {
            this.warnings = warnings;
            return this;
        }

        public FullSyncInfo build() {
            FullSyncInfo result = new FullSyncInfo();
            result.setDataStreamingFromSourceEndTime(this.dataStreamingFromSourceEndTime);
            result.setDataStreamingFromSourceProgress(this.dataStreamingFromSourceProgress);
            result.setDataStreamingFromSourceStartTime(this.dataStreamingFromSourceStartTime);
            result.setEndTime(this.endTime);
            result.setErrors(this.errors);
            result.setFullSyncId(this.fullSyncId);
            result.setReason(this.reason);
            result.setReasonCode(this.reasonCode);
            result.setReceiverEndTime(this.receiverEndTime);
            result.setReceiverStartTime(this.receiverStartTime);
            result.setReceiverState(this.receiverState);
            result.setReceiverTimeToApplyInMillis(this.receiverTimeToApplyInMillis);
            result.setStage(this.stage);
            result.setStartTime(this.startTime);
            result.setStatus(this.status);
            result.setWarnings(this.warnings);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("data_streaming_from_source_end_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("data_streaming_from_source_end_time",
                                                                                "dataStreamingFromSourceEndTime",
                                                                                "getDataStreamingFromSourceEndTime",
                                                                                "setDataStreamingFromSourceEndTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("data_streaming_from_source_progress", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("data_streaming_from_source_progress",
                                                                                "dataStreamingFromSourceProgress",
                                                                                "getDataStreamingFromSourceProgress",
                                                                                "setDataStreamingFromSourceProgress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("data_streaming_from_source_start_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("data_streaming_from_source_start_time",
                                                                                "dataStreamingFromSourceStartTime",
                                                                                "getDataStreamingFromSourceStartTime",
                                                                                "setDataStreamingFromSourceStartTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("end_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("end_time",
                                                                                "endTime",
                                                                                "getEndTime",
                                                                                "setEndTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("errors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("errors",
                                                                                "errors",
                                                                                "getErrors",
                                                                                "setErrors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("fullSyncId", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fullSyncId",
                                                                                "fullSyncId",
                                                                                "getFullSyncId",
                                                                                "setFullSyncId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reason", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reason",
                                                                                "reason",
                                                                                "getReason",
                                                                                "setReason");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reason_code", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reason_code",
                                                                                "reasonCode",
                                                                                "getReasonCode",
                                                                                "setReasonCode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("receiver_end_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("receiver_end_time",
                                                                                "receiverEndTime",
                                                                                "getReceiverEndTime",
                                                                                "setReceiverEndTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("receiver_start_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("receiver_start_time",
                                                                                "receiverStartTime",
                                                                                "getReceiverStartTime",
                                                                                "setReceiverStartTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("receiver_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("receiver_state",
                                                                                "receiverState",
                                                                                "getReceiverState",
                                                                                "setReceiverState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("receiver_time_to_apply_in_millis", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("receiver_time_to_apply_in_millis",
                                                                                "receiverTimeToApplyInMillis",
                                                                                "getReceiverTimeToApplyInMillis",
                                                                                "setReceiverTimeToApplyInMillis");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("stage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("stage",
                                                                                "stage",
                                                                                "getStage",
                                                                                "setStage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("start_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("start_time",
                                                                                "startTime",
                                                                                "getStartTime",
                                                                                "setStartTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("warnings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("warnings",
                                                                                "warnings",
                                                                                "getWarnings",
                                                                                "setWarnings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.full_sync_info",
                                                            fields,
                                                            com.vmware.nsx_policy.model.FullSyncInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

