/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Describes usage summary of virtual servers, pools and pool members for all load
 * balancer services.
 */
public final class LBServiceUsageSummary implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String POOL_MEMBER_SEVERITY_GREEN = "GREEN";

    public static final java.lang.String POOL_MEMBER_SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String POOL_MEMBER_SEVERITY_RED = "RED";

    public static final java.lang.String POOL_SEVERITY_GREEN = "GREEN";

    public static final java.lang.String POOL_SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String POOL_SEVERITY_RED = "RED";

    public static final java.lang.String VIRTUAL_SERVER_SEVERITY_GREEN = "GREEN";

    public static final java.lang.String VIRTUAL_SERVER_SEVERITY_ORANGE = "ORANGE";

    public static final java.lang.String VIRTUAL_SERVER_SEVERITY_RED = "RED";

    private java.lang.Long currentPoolCount;

    private java.lang.Long currentPoolMemberCount;

    private java.lang.Long currentVirtualServerCount;

    private java.lang.Long poolCapacity;

    private java.lang.Long poolMemberCapacity;

    private java.lang.String poolMemberSeverity;

    private java.lang.Double poolMemberUsagePercentage;

    private java.lang.String poolSeverity;

    private java.lang.Double poolUsagePercentage;

    private java.util.List<com.vmware.nsx_policy.model.LBServiceCountPerSeverity> serviceCounts;

    private java.util.List<com.vmware.nsx_policy.model.LBServiceUsage> serviceUsages;

    private java.lang.Long virtualServerCapacity;

    private java.lang.String virtualServerSeverity;

    private java.lang.Double virtualServerUsagePercentage;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBServiceUsageSummary() {
    }

    protected LBServiceUsageSummary(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The current count of pools configured for all load balancer services. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolCount() {
        return this.currentPoolCount;
    }

    /**
     * The current count of pools configured for all load balancer services. format:
     * int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolCount New value for the property.
     */
    public void setCurrentPoolCount(java.lang.Long currentPoolCount) {
        this.currentPoolCount = currentPoolCount;
    }

    /**
     * The current count of pool members configured for all load balancer services.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentPoolMemberCount() {
        return this.currentPoolMemberCount;
    }

    /**
     * The current count of pool members configured for all load balancer services.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentPoolMemberCount New value for the property.
     */
    public void setCurrentPoolMemberCount(java.lang.Long currentPoolMemberCount) {
        this.currentPoolMemberCount = currentPoolMemberCount;
    }

    /**
     * The current count of virtual servers configured for all load balancer services.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCurrentVirtualServerCount() {
        return this.currentVirtualServerCount;
    }

    /**
     * The current count of virtual servers configured for all load balancer services.
     * format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param currentVirtualServerCount New value for the property.
     */
    public void setCurrentVirtualServerCount(java.lang.Long currentVirtualServerCount) {
        this.currentVirtualServerCount = currentVirtualServerCount;
    }

    /**
     * Pool capacity means maximum number of pools which can be configured for all load
     * balancer services. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPoolCapacity() {
        return this.poolCapacity;
    }

    /**
     * Pool capacity means maximum number of pools which can be configured for all load
     * balancer services. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolCapacity New value for the property.
     */
    public void setPoolCapacity(java.lang.Long poolCapacity) {
        this.poolCapacity = poolCapacity;
    }

    /**
     * Pool capacity means maximum number of pool members which can be configured for
     * all load balancer services. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPoolMemberCapacity() {
        return this.poolMemberCapacity;
    }

    /**
     * Pool capacity means maximum number of pool members which can be configured for
     * all load balancer services. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolMemberCapacity New value for the property.
     */
    public void setPoolMemberCapacity(java.lang.Long poolMemberCapacity) {
        this.poolMemberCapacity = poolMemberCapacity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_GREEN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_ORANGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_RED}</li>
     * </ul> The severity calculation is based on the overall usage percentage of pool
     * members for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPoolMemberSeverity() {
        return this.poolMemberSeverity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_GREEN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_ORANGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_RED}</li>
     * </ul> The severity calculation is based on the overall usage percentage of pool
     * members for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolMemberSeverity New value for the property.
     */
    public void setPoolMemberSeverity(java.lang.String poolMemberSeverity) {
        this.poolMemberSeverity = poolMemberSeverity;
    }

    /**
     * Overall pool member usage percentage for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getPoolMemberUsagePercentage() {
        return this.poolMemberUsagePercentage;
    }

    /**
     * Overall pool member usage percentage for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolMemberUsagePercentage New value for the property.
     */
    public void setPoolMemberUsagePercentage(java.lang.Double poolMemberUsagePercentage) {
        this.poolMemberUsagePercentage = poolMemberUsagePercentage;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_GREEN}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_ORANGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_RED}</li> </ul>
     * The severity calculation is based on the overall usage percentage of pools for
     * all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPoolSeverity() {
        return this.poolSeverity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_GREEN}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_ORANGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_RED}</li> </ul>
     * The severity calculation is based on the overall usage percentage of pools for
     * all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolSeverity New value for the property.
     */
    public void setPoolSeverity(java.lang.String poolSeverity) {
        this.poolSeverity = poolSeverity;
    }

    /**
     * Overall pool usage percentage for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getPoolUsagePercentage() {
        return this.poolUsagePercentage;
    }

    /**
     * Overall pool usage percentage for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param poolUsagePercentage New value for the property.
     */
    public void setPoolUsagePercentage(java.lang.Double poolUsagePercentage) {
        this.poolUsagePercentage = poolUsagePercentage;
    }

    /**
     * The service count for each load balancer usage severity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.LBServiceCountPerSeverity> getServiceCounts() {
        return this.serviceCounts;
    }

    /**
     * The service count for each load balancer usage severity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serviceCounts New value for the property.
     */
    public void setServiceCounts(java.util.List<com.vmware.nsx_policy.model.LBServiceCountPerSeverity> serviceCounts) {
        this.serviceCounts = serviceCounts;
    }

    /**
     * The property identifies all lb service usages. By default, it is not included in
     * response. It exists when parameter ?include_usages=true.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.LBServiceUsage> getServiceUsages() {
        return this.serviceUsages;
    }

    /**
     * The property identifies all lb service usages. By default, it is not included in
     * response. It exists when parameter ?include_usages=true.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serviceUsages New value for the property.
     */
    public void setServiceUsages(java.util.List<com.vmware.nsx_policy.model.LBServiceUsage> serviceUsages) {
        this.serviceUsages = serviceUsages;
    }

    /**
     * Virtual server capacity means maximum number of virtual servers which can be
     * configured for all load balancer services. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getVirtualServerCapacity() {
        return this.virtualServerCapacity;
    }

    /**
     * Virtual server capacity means maximum number of virtual servers which can be
     * configured for all load balancer services. format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param virtualServerCapacity New value for the property.
     */
    public void setVirtualServerCapacity(java.lang.Long virtualServerCapacity) {
        this.virtualServerCapacity = virtualServerCapacity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_GREEN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_ORANGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_RED}</li>
     * </ul> The severity calculation is based on the overall usage percentage of
     * virtual servers for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVirtualServerSeverity() {
        return this.virtualServerSeverity;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_GREEN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_ORANGE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_RED}</li>
     * </ul> The severity calculation is based on the overall usage percentage of
     * virtual servers for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param virtualServerSeverity New value for the property.
     */
    public void setVirtualServerSeverity(java.lang.String virtualServerSeverity) {
        this.virtualServerSeverity = virtualServerSeverity;
    }

    /**
     * Overall virtual server usage percentage for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getVirtualServerUsagePercentage() {
        return this.virtualServerUsagePercentage;
    }

    /**
     * Overall virtual server usage percentage for all load balancer services.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param virtualServerUsagePercentage New value for the property.
     */
    public void setVirtualServerUsagePercentage(java.lang.Double virtualServerUsagePercentage) {
        this.virtualServerUsagePercentage = virtualServerUsagePercentage;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBServiceUsageSummary;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("current_pool_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolCount, this._getType().getField("current_pool_count")));
        structValue.setField("current_pool_member_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentPoolMemberCount, this._getType().getField("current_pool_member_count")));
        structValue.setField("current_virtual_server_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.currentVirtualServerCount, this._getType().getField("current_virtual_server_count")));
        structValue.setField("pool_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolCapacity, this._getType().getField("pool_capacity")));
        structValue.setField("pool_member_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolMemberCapacity, this._getType().getField("pool_member_capacity")));
        structValue.setField("pool_member_severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolMemberSeverity, this._getType().getField("pool_member_severity")));
        structValue.setField("pool_member_usage_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolMemberUsagePercentage, this._getType().getField("pool_member_usage_percentage")));
        structValue.setField("pool_severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolSeverity, this._getType().getField("pool_severity")));
        structValue.setField("pool_usage_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolUsagePercentage, this._getType().getField("pool_usage_percentage")));
        structValue.setField("service_counts",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceCounts, this._getType().getField("service_counts")));
        structValue.setField("service_usages",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceUsages, this._getType().getField("service_usages")));
        structValue.setField("virtual_server_capacity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.virtualServerCapacity, this._getType().getField("virtual_server_capacity")));
        structValue.setField("virtual_server_severity",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.virtualServerSeverity, this._getType().getField("virtual_server_severity")));
        structValue.setField("virtual_server_usage_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.virtualServerUsagePercentage, this._getType().getField("virtual_server_usage_percentage")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBServiceUsageSummary;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBServiceUsageSummary.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBServiceUsageSummary _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBServiceUsageSummary(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBServiceUsageSummary _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBServiceUsageSummary(structValue);
    }

    /**
     * Builder class for {@link LBServiceUsageSummary}.
     */
    public static final class Builder {
        private java.lang.Long currentPoolCount;
        private java.lang.Long currentPoolMemberCount;
        private java.lang.Long currentVirtualServerCount;
        private java.lang.Long poolCapacity;
        private java.lang.Long poolMemberCapacity;
        private java.lang.String poolMemberSeverity;
        private java.lang.Double poolMemberUsagePercentage;
        private java.lang.String poolSeverity;
        private java.lang.Double poolUsagePercentage;
        private java.util.List<com.vmware.nsx_policy.model.LBServiceCountPerSeverity> serviceCounts;
        private java.util.List<com.vmware.nsx_policy.model.LBServiceUsage> serviceUsages;
        private java.lang.Long virtualServerCapacity;
        private java.lang.String virtualServerSeverity;
        private java.lang.Double virtualServerUsagePercentage;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBServiceUsageSummary}.
         */
        public Builder() {
        }

        /**
         * The current count of pools configured for all load balancer services. format:
         * int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolCount New value for the property.
         */
        public Builder setCurrentPoolCount(java.lang.Long currentPoolCount) {
            this.currentPoolCount = currentPoolCount;
            return this;
        }

        /**
         * The current count of pool members configured for all load balancer services.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentPoolMemberCount New value for the property.
         */
        public Builder setCurrentPoolMemberCount(java.lang.Long currentPoolMemberCount) {
            this.currentPoolMemberCount = currentPoolMemberCount;
            return this;
        }

        /**
         * The current count of virtual servers configured for all load balancer services.
         * format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param currentVirtualServerCount New value for the property.
         */
        public Builder setCurrentVirtualServerCount(java.lang.Long currentVirtualServerCount) {
            this.currentVirtualServerCount = currentVirtualServerCount;
            return this;
        }

        /**
         * Pool capacity means maximum number of pools which can be configured for all load
         * balancer services. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolCapacity New value for the property.
         */
        public Builder setPoolCapacity(java.lang.Long poolCapacity) {
            this.poolCapacity = poolCapacity;
            return this;
        }

        /**
         * Pool capacity means maximum number of pool members which can be configured for
         * all load balancer services. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolMemberCapacity New value for the property.
         */
        public Builder setPoolMemberCapacity(java.lang.Long poolMemberCapacity) {
            this.poolMemberCapacity = poolMemberCapacity;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_GREEN}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_ORANGE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_MEMBER_SEVERITY_RED}</li>
         * </ul> The severity calculation is based on the overall usage percentage of pool
         * members for all load balancer services.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolMemberSeverity New value for the property.
         */
        public Builder setPoolMemberSeverity(java.lang.String poolMemberSeverity) {
            this.poolMemberSeverity = poolMemberSeverity;
            return this;
        }

        /**
         * Overall pool member usage percentage for all load balancer services.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolMemberUsagePercentage New value for the property.
         */
        public Builder setPoolMemberUsagePercentage(java.lang.Double poolMemberUsagePercentage) {
            this.poolMemberUsagePercentage = poolMemberUsagePercentage;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_GREEN}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_ORANGE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#POOL_SEVERITY_RED}</li> </ul>
         * The severity calculation is based on the overall usage percentage of pools for
         * all load balancer services.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolSeverity New value for the property.
         */
        public Builder setPoolSeverity(java.lang.String poolSeverity) {
            this.poolSeverity = poolSeverity;
            return this;
        }

        /**
         * Overall pool usage percentage for all load balancer services.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param poolUsagePercentage New value for the property.
         */
        public Builder setPoolUsagePercentage(java.lang.Double poolUsagePercentage) {
            this.poolUsagePercentage = poolUsagePercentage;
            return this;
        }

        /**
         * The service count for each load balancer usage severity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serviceCounts New value for the property.
         */
        public Builder setServiceCounts(java.util.List<com.vmware.nsx_policy.model.LBServiceCountPerSeverity> serviceCounts) {
            this.serviceCounts = serviceCounts;
            return this;
        }

        /**
         * The property identifies all lb service usages. By default, it is not included in
         * response. It exists when parameter ?include_usages=true.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serviceUsages New value for the property.
         */
        public Builder setServiceUsages(java.util.List<com.vmware.nsx_policy.model.LBServiceUsage> serviceUsages) {
            this.serviceUsages = serviceUsages;
            return this;
        }

        /**
         * Virtual server capacity means maximum number of virtual servers which can be
         * configured for all load balancer services. format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param virtualServerCapacity New value for the property.
         */
        public Builder setVirtualServerCapacity(java.lang.Long virtualServerCapacity) {
            this.virtualServerCapacity = virtualServerCapacity;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_GREEN}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_ORANGE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.LBServiceUsageSummary#VIRTUAL_SERVER_SEVERITY_RED}</li>
         * </ul> The severity calculation is based on the overall usage percentage of
         * virtual servers for all load balancer services.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param virtualServerSeverity New value for the property.
         */
        public Builder setVirtualServerSeverity(java.lang.String virtualServerSeverity) {
            this.virtualServerSeverity = virtualServerSeverity;
            return this;
        }

        /**
         * Overall virtual server usage percentage for all load balancer services.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param virtualServerUsagePercentage New value for the property.
         */
        public Builder setVirtualServerUsagePercentage(java.lang.Double virtualServerUsagePercentage) {
            this.virtualServerUsagePercentage = virtualServerUsagePercentage;
            return this;
        }

        public LBServiceUsageSummary build() {
            LBServiceUsageSummary result = new LBServiceUsageSummary();
            result.setCurrentPoolCount(this.currentPoolCount);
            result.setCurrentPoolMemberCount(this.currentPoolMemberCount);
            result.setCurrentVirtualServerCount(this.currentVirtualServerCount);
            result.setPoolCapacity(this.poolCapacity);
            result.setPoolMemberCapacity(this.poolMemberCapacity);
            result.setPoolMemberSeverity(this.poolMemberSeverity);
            result.setPoolMemberUsagePercentage(this.poolMemberUsagePercentage);
            result.setPoolSeverity(this.poolSeverity);
            result.setPoolUsagePercentage(this.poolUsagePercentage);
            result.setServiceCounts(this.serviceCounts);
            result.setServiceUsages(this.serviceUsages);
            result.setVirtualServerCapacity(this.virtualServerCapacity);
            result.setVirtualServerSeverity(this.virtualServerSeverity);
            result.setVirtualServerUsagePercentage(this.virtualServerUsagePercentage);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("current_pool_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_count",
                                                                                "currentPoolCount",
                                                                                "getCurrentPoolCount",
                                                                                "setCurrentPoolCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_pool_member_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_pool_member_count",
                                                                                "currentPoolMemberCount",
                                                                                "getCurrentPoolMemberCount",
                                                                                "setCurrentPoolMemberCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("current_virtual_server_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("current_virtual_server_count",
                                                                                "currentVirtualServerCount",
                                                                                "getCurrentVirtualServerCount",
                                                                                "setCurrentVirtualServerCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_capacity",
                                                                                "poolCapacity",
                                                                                "getPoolCapacity",
                                                                                "setPoolCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_member_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_member_capacity",
                                                                                "poolMemberCapacity",
                                                                                "getPoolMemberCapacity",
                                                                                "setPoolMemberCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_member_severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_member_severity",
                                                                                "poolMemberSeverity",
                                                                                "getPoolMemberSeverity",
                                                                                "setPoolMemberSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_member_usage_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_member_usage_percentage",
                                                                                "poolMemberUsagePercentage",
                                                                                "getPoolMemberUsagePercentage",
                                                                                "setPoolMemberUsagePercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_severity",
                                                                                "poolSeverity",
                                                                                "getPoolSeverity",
                                                                                "setPoolSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_usage_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_usage_percentage",
                                                                                "poolUsagePercentage",
                                                                                "getPoolUsagePercentage",
                                                                                "setPoolUsagePercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_counts", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBServiceCountPerSeverity; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_counts",
                                                                                "serviceCounts",
                                                                                "getServiceCounts",
                                                                                "setServiceCounts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_usages", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBServiceUsage; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_usages",
                                                                                "serviceUsages",
                                                                                "getServiceUsages",
                                                                                "setServiceUsages");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("virtual_server_capacity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("virtual_server_capacity",
                                                                                "virtualServerCapacity",
                                                                                "getVirtualServerCapacity",
                                                                                "setVirtualServerCapacity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("virtual_server_severity", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("virtual_server_severity",
                                                                                "virtualServerSeverity",
                                                                                "getVirtualServerSeverity",
                                                                                "setVirtualServerSeverity");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("virtual_server_usage_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("virtual_server_usage_percentage",
                                                                                "virtualServerUsagePercentage",
                                                                                "getVirtualServerUsagePercentage",
                                                                                "setVirtualServerUsagePercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_service_usage_summary",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBServiceUsageSummary.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

