/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * All the types of LBVirtualServer extend from this abstract class. This is
 * present for extensibility.
 */
public final class LBVirtualServer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx_policy.model.Tag> tags;

    private java.lang.String originSiteId;

    private java.lang.String ownerId;

    private java.lang.String parentPath;

    private java.lang.String path;

    private java.lang.String realizationId;

    private java.lang.String relativePath;

    private java.lang.String remotePath;

    private java.lang.String uniqueId;

    private java.util.List<com.vmware.vapi.bindings.Structure> children;

    private java.lang.Boolean markedForDelete;

    private java.lang.Boolean overridden;

    private com.vmware.nsx_policy.model.LBAccessListControl accessListControl;

    private java.lang.Boolean accessLogEnabled;

    private java.lang.String applicationProfilePath;

    private com.vmware.nsx_policy.model.LBClientSslProfileBinding clientSslProfileBinding;

    private java.util.List<java.lang.String> defaultPoolMemberPorts;

    private java.lang.Boolean enabled;

    private java.lang.String ipAddress;

    private java.lang.String lbPersistenceProfilePath;

    private java.lang.String lbServicePath;

    private java.lang.Boolean logSignificantEventOnly;

    private java.lang.Long maxConcurrentConnections;

    private java.lang.Long maxNewConnectionRate;

    private java.lang.String poolPath;

    private java.util.List<java.lang.String> ports;

    private java.util.List<com.vmware.nsx_policy.model.LBRule> rules;

    private com.vmware.nsx_policy.model.LBServerSslProfileBinding serverSslProfileBinding;

    private java.lang.String sorryPoolPath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBVirtualServer() {
    }

    protected LBVirtualServer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOriginSiteId() {
        return this.originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing which site owns an object.
     * This is used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param originSiteId New value for the property.
     */
    public void setOriginSiteId(java.lang.String originSiteId) {
        this.originSiteId = originSiteId;
    }

    /**
     * This is a UUID generated by the system for knowing who owns this object. This is
     * used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOwnerId() {
        return this.ownerId;
    }

    /**
     * This is a UUID generated by the system for knowing who owns this object. This is
     * used in NSX+.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param ownerId New value for the property.
     */
    public void setOwnerId(java.lang.String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getParentPath() {
        return this.parentPath;
    }

    /**
     * Path of its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param parentPath New value for the property.
     */
    public void setParentPath(java.lang.String parentPath) {
        this.parentPath = parentPath;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPath() {
        return this.path;
    }

    /**
     * Absolute path of this object
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param path New value for the property.
     */
    public void setPath(java.lang.String path) {
        this.path = path;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated their unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRealizationId() {
        return this.realizationId;
    }

    /**
     * This is a UUID generated by the system for realizing the entity object. In most
     * cases this should be same as 'unique_id' of the entity. However, in some cases
     * this can be different because of entities have migrated their unique identifier
     * to NSX Policy intent objects later in the timeline and did not use unique_id for
     * realization. Realization id is helpful for users to debug data path to correlate
     * the configuration with corresponding intent.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param realizationId New value for the property.
     */
    public void setRealizationId(java.lang.String realizationId) {
        this.realizationId = realizationId;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Path relative from its parent
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param relativePath New value for the property.
     */
    public void setRelativePath(java.lang.String relativePath) {
        this.relativePath = relativePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the NSX+
     * service, and path of the object on NSX+ service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRemotePath() {
        return this.remotePath;
    }

    /**
     * This is the path of the object on the local managers when queried on the NSX+
     * service, and path of the object on NSX+ service when queried from the local
     * managers.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param remotePath New value for the property.
     */
    public void setRemotePath(java.lang.String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entities in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUniqueId() {
        return this.uniqueId;
    }

    /**
     * This is a UUID generated by the GM/LM to uniquely identify entities in a
     * federated environment. For entities that are stretched across multiple sites,
     * the same ID will be used on all the stretched sites.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param uniqueId New value for the property.
     */
    public void setUniqueId(java.lang.String uniqueId) {
        this.uniqueId = uniqueId;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
     * value of this class as a return value, the property will contain all the
     * properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getChildren() {
        return this.children;
    }

    /**
     * Subtree for this type within policy tree containing nested elements. Note that
     * this type is applicable to be used in Hierarchical API only.
     *
     * @param children New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
     * value of this class as a return value, the property will contain all the
     * properties defined in {@link
     * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
     */
    public void setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
        this.children = children;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMarkedForDelete() {
        return this.markedForDelete;
    }

    /**
     * Intent objects are not directly deleted from the system when a delete is invoked
     * on them. They are marked for deletion and only when all the realized entities
     * for that intent object gets deleted, the intent object is deleted. Objects that
     * are marked for deletion are not returned in GET call. One can use the search API
     * to get these objects.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param markedForDelete New value for the property.
     */
    public void setMarkedForDelete(java.lang.Boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getOverridden() {
        return this.overridden;
    }

    /**
     * Global intent objects cannot be modified by the user. However, certain global
     * intent objects can be overridden locally by use of this property. In such cases,
     * the overridden local values take precedence over the globally defined values for
     * the properties.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param overridden New value for the property.
     */
    public void setOverridden(java.lang.Boolean overridden) {
        this.overridden = overridden;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.LBAccessListControl getAccessListControl() {
        return this.accessListControl;
    }

    /**
     *
     *
     * @param accessListControl New value for the property.
     */
    public void setAccessListControl(com.vmware.nsx_policy.model.LBAccessListControl accessListControl) {
        this.accessListControl = accessListControl;
    }

    /**
     * If access log is enabled, all HTTP requests sent to L7 virtual server are logged
     * to the access log file. Both successful returns information responses(1xx),
     * successful responses(2xx), redirection messages(3xx) and unsuccessful requests,
     * backend server returns 4xx or 5xx, are logged to access log, if enabled. All L4
     * virtual server connections are also logged to the access log if enabled. The
     * non-significant events such as successful requests are not logged if
     * log_significant_event_only is set to true.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    /**
     * If access log is enabled, all HTTP requests sent to L7 virtual server are logged
     * to the access log file. Both successful returns information responses(1xx),
     * successful responses(2xx), redirection messages(3xx) and unsuccessful requests,
     * backend server returns 4xx or 5xx, are logged to access log, if enabled. All L4
     * virtual server connections are also logged to the access log if enabled. The
     * non-significant events such as successful requests are not logged if
     * log_significant_event_only is set to true.
     *
     * @param accessLogEnabled New value for the property.
     */
    public void setAccessLogEnabled(java.lang.Boolean accessLogEnabled) {
        this.accessLogEnabled = accessLogEnabled;
    }

    /**
     * The application profile defines the application protocol characteristics. It is
     * used to influence how load balancing is performed. Currently, LBFastTCPProfile,
     * LBFastUDPProfile and LBHttpProfile, etc are supported.
     *
     * @return The current value of the property.
     */
    public java.lang.String getApplicationProfilePath() {
        return this.applicationProfilePath;
    }

    /**
     * The application profile defines the application protocol characteristics. It is
     * used to influence how load balancing is performed. Currently, LBFastTCPProfile,
     * LBFastUDPProfile and LBHttpProfile, etc are supported.
     *
     * @param applicationProfilePath New value for the property.
     */
    public void setApplicationProfilePath(java.lang.String applicationProfilePath) {
        this.applicationProfilePath = applicationProfilePath;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.LBClientSslProfileBinding getClientSslProfileBinding() {
        return this.clientSslProfileBinding;
    }

    /**
     *
     *
     * @param clientSslProfileBinding New value for the property.
     */
    public void setClientSslProfileBinding(com.vmware.nsx_policy.model.LBClientSslProfileBinding clientSslProfileBinding) {
        this.clientSslProfileBinding = clientSslProfileBinding;
    }

    /**
     * Default pool member ports when member port is not defined. format: port-or-range
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDefaultPoolMemberPorts() {
        return this.defaultPoolMemberPorts;
    }

    /**
     * Default pool member ports when member port is not defined. format: port-or-range
     *
     * @param defaultPoolMemberPorts New value for the property.
     */
    public void setDefaultPoolMemberPorts(java.util.List<java.lang.String> defaultPoolMemberPorts) {
        this.defaultPoolMemberPorts = defaultPoolMemberPorts;
    }

    /**
     * Flag to enable the load balancer virtual server.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Flag to enable the load balancer virtual server.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * Configures the IP address of the LBVirtualServer where it receives all client
     * connections and distributes them among the backend servers. format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * Configures the IP address of the LBVirtualServer where it receives all client
     * connections and distributes them among the backend servers. format: ip
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.lang.String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Path to optional object that enables persistence on a virtual server allowing
     * related client connections to be sent to the same backend server. Persistence is
     * deactivated by default.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLbPersistenceProfilePath() {
        return this.lbPersistenceProfilePath;
    }

    /**
     * Path to optional object that enables persistence on a virtual server allowing
     * related client connections to be sent to the same backend server. Persistence is
     * deactivated by default.
     *
     * @param lbPersistenceProfilePath New value for the property.
     */
    public void setLbPersistenceProfilePath(java.lang.String lbPersistenceProfilePath) {
        this.lbPersistenceProfilePath = lbPersistenceProfilePath;
    }

    /**
     * virtual servers can be associated to LBService(which is similar to
     * physical/virtual load balancer), LB virtual servers, pools and other entities
     * could be defined independently, the LBService identifier list here would be used
     * to maintain the relationship of LBService and other LB entities.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLbServicePath() {
        return this.lbServicePath;
    }

    /**
     * virtual servers can be associated to LBService(which is similar to
     * physical/virtual load balancer), LB virtual servers, pools and other entities
     * could be defined independently, the LBService identifier list here would be used
     * to maintain the relationship of LBService and other LB entities.
     *
     * @param lbServicePath New value for the property.
     */
    public void setLbServicePath(java.lang.String lbServicePath) {
        this.lbServicePath = lbServicePath;
    }

    /**
     * The property log_significant_event_only can take effect only when
     * access_log_enabled is true. If log_significant_event_only is true, significant
     * events are logged in access log. For L4 virtual server, significant event means
     * unsuccessful(error or dropped) TCP/UDP connections. For L7 virtual server,
     * significant event means unsuccessful connections or HTTP/HTTPS requests which
     * have error response code(e.g. 4xx, 5xx).
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getLogSignificantEventOnly() {
        return this.logSignificantEventOnly;
    }

    /**
     * The property log_significant_event_only can take effect only when
     * access_log_enabled is true. If log_significant_event_only is true, significant
     * events are logged in access log. For L4 virtual server, significant event means
     * unsuccessful(error or dropped) TCP/UDP connections. For L7 virtual server,
     * significant event means unsuccessful connections or HTTP/HTTPS requests which
     * have error response code(e.g. 4xx, 5xx).
     *
     * @param logSignificantEventOnly New value for the property.
     */
    public void setLogSignificantEventOnly(java.lang.Boolean logSignificantEventOnly) {
        this.logSignificantEventOnly = logSignificantEventOnly;
    }

    /**
     * To ensure one virtual server does not over consume resources, affecting other
     * applications hosted on the same LBS, connections to a virtual server can be
     * capped. If it is not specified, it means that connections are unlimited. The
     * property is deprecated as NSX-T Load Balancer is deprecated. format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    /**
     * To ensure one virtual server does not over consume resources, affecting other
     * applications hosted on the same LBS, connections to a virtual server can be
     * capped. If it is not specified, it means that connections are unlimited. The
     * property is deprecated as NSX-T Load Balancer is deprecated. format: int64
     *
     * @param maxConcurrentConnections New value for the property.
     */
    @Deprecated
    public void setMaxConcurrentConnections(java.lang.Long maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
    }

    /**
     * To ensure one virtual server does not over consume resources, connections to a
     * member can be rate limited. If it is not specified, it means that connection
     * rate is unlimited. The property is deprecated as NSX-T Load Balancer is
     * deprecated. format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getMaxNewConnectionRate() {
        return this.maxNewConnectionRate;
    }

    /**
     * To ensure one virtual server does not over consume resources, connections to a
     * member can be rate limited. If it is not specified, it means that connection
     * rate is unlimited. The property is deprecated as NSX-T Load Balancer is
     * deprecated. format: int64
     *
     * @param maxNewConnectionRate New value for the property.
     */
    @Deprecated
    public void setMaxNewConnectionRate(java.lang.Long maxNewConnectionRate) {
        this.maxNewConnectionRate = maxNewConnectionRate;
    }

    /**
     * The server pool(LBPool) contains backend servers. Server pool consists of one or
     * more servers, also referred to as pool members, that are similarly configured
     * and are running the same application.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPoolPath() {
        return this.poolPath;
    }

    /**
     * The server pool(LBPool) contains backend servers. Server pool consists of one or
     * more servers, also referred to as pool members, that are similarly configured
     * and are running the same application.
     *
     * @param poolPath New value for the property.
     */
    public void setPoolPath(java.lang.String poolPath) {
        this.poolPath = poolPath;
    }

    /**
     * Ports contains a list of at least one port or port range such as \"80\",
     * \"1234-1236\". Each port element in the list should be a single port or a single
     * port range. format: port-or-range
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getPorts() {
        return this.ports;
    }

    /**
     * Ports contains a list of at least one port or port range such as \"80\",
     * \"1234-1236\". Each port element in the list should be a single port or a single
     * port range. format: port-or-range
     *
     * @param ports New value for the property.
     */
    public void setPorts(java.util.List<java.lang.String> ports) {
        this.ports = ports;
    }

    /**
     * Load balancer rules allow customization of load balancing behavior using
     * match/action rules. Currently, load balancer rules are supported for only layer
     * 7 virtual servers with LBHttpProfile. The property is deprecated as NSX-T Load
     * Balancer is deprecated.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx_policy.model.LBRule> getRules() {
        return this.rules;
    }

    /**
     * Load balancer rules allow customization of load balancing behavior using
     * match/action rules. Currently, load balancer rules are supported for only layer
     * 7 virtual servers with LBHttpProfile. The property is deprecated as NSX-T Load
     * Balancer is deprecated.
     *
     * @param rules New value for the property.
     */
    @Deprecated
    public void setRules(java.util.List<com.vmware.nsx_policy.model.LBRule> rules) {
        this.rules = rules;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_policy.model.LBServerSslProfileBinding getServerSslProfileBinding() {
        return this.serverSslProfileBinding;
    }

    /**
     *
     *
     * @param serverSslProfileBinding New value for the property.
     */
    public void setServerSslProfileBinding(com.vmware.nsx_policy.model.LBServerSslProfileBinding serverSslProfileBinding) {
        this.serverSslProfileBinding = serverSslProfileBinding;
    }

    /**
     * When load balancer can not select a backend server to serve the request in
     * default pool or pool in rules, the request would be served by sorry server pool.
     * The property is deprecated as NSX-T Load Balancer is deprecated.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getSorryPoolPath() {
        return this.sorryPoolPath;
    }

    /**
     * When load balancer can not select a backend server to serve the request in
     * default pool or pool in rules, the request would be served by sorry server pool.
     * The property is deprecated as NSX-T Load Balancer is deprecated.
     *
     * @param sorryPoolPath New value for the property.
     */
    @Deprecated
    public void setSorryPoolPath(java.lang.String sorryPoolPath) {
        this.sorryPoolPath = sorryPoolPath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBVirtualServer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("origin_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.originSiteId, this._getType().getField("origin_site_id")));
        structValue.setField("owner_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ownerId, this._getType().getField("owner_id")));
        structValue.setField("parent_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.parentPath, this._getType().getField("parent_path")));
        structValue.setField("path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.path, this._getType().getField("path")));
        structValue.setField("realization_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.realizationId, this._getType().getField("realization_id")));
        structValue.setField("relative_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.relativePath, this._getType().getField("relative_path")));
        structValue.setField("remote_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remotePath, this._getType().getField("remote_path")));
        structValue.setField("unique_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uniqueId, this._getType().getField("unique_id")));
        structValue.setField("children",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.children, this._getType().getField("children")));
        structValue.setField("marked_for_delete",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.markedForDelete, this._getType().getField("marked_for_delete")));
        structValue.setField("overridden",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.overridden, this._getType().getField("overridden")));
        structValue.setField("access_list_control",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.accessListControl, this._getType().getField("access_list_control")));
        structValue.setField("access_log_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.accessLogEnabled, this._getType().getField("access_log_enabled")));
        structValue.setField("application_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.applicationProfilePath, this._getType().getField("application_profile_path")));
        structValue.setField("client_ssl_profile_binding",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientSslProfileBinding, this._getType().getField("client_ssl_profile_binding")));
        structValue.setField("default_pool_member_ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultPoolMemberPorts, this._getType().getField("default_pool_member_ports")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("lb_persistence_profile_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lbPersistenceProfilePath, this._getType().getField("lb_persistence_profile_path")));
        structValue.setField("lb_service_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lbServicePath, this._getType().getField("lb_service_path")));
        structValue.setField("log_significant_event_only",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.logSignificantEventOnly, this._getType().getField("log_significant_event_only")));
        structValue.setField("max_concurrent_connections",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxConcurrentConnections, this._getType().getField("max_concurrent_connections")));
        structValue.setField("max_new_connection_rate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxNewConnectionRate, this._getType().getField("max_new_connection_rate")));
        structValue.setField("pool_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.poolPath, this._getType().getField("pool_path")));
        structValue.setField("ports",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ports, this._getType().getField("ports")));
        structValue.setField("rules",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rules, this._getType().getField("rules")));
        structValue.setField("server_ssl_profile_binding",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serverSslProfileBinding, this._getType().getField("server_ssl_profile_binding")));
        structValue.setField("sorry_pool_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sorryPoolPath, this._getType().getField("sorry_pool_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.LBVirtualServer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.LBVirtualServer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBVirtualServer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBVirtualServer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBVirtualServer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBVirtualServer(structValue);
    }

    /**
     * Builder class for {@link LBVirtualServer}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx_policy.model.Tag> tags;
        private java.lang.String originSiteId;
        private java.lang.String ownerId;
        private java.lang.String parentPath;
        private java.lang.String path;
        private java.lang.String realizationId;
        private java.lang.String relativePath;
        private java.lang.String remotePath;
        private java.lang.String uniqueId;
        private java.util.List<com.vmware.vapi.bindings.Structure> children;
        private java.lang.Boolean markedForDelete;
        private java.lang.Boolean overridden;
        private com.vmware.nsx_policy.model.LBAccessListControl accessListControl;
        private java.lang.Boolean accessLogEnabled;
        private java.lang.String applicationProfilePath;
        private com.vmware.nsx_policy.model.LBClientSslProfileBinding clientSslProfileBinding;
        private java.util.List<java.lang.String> defaultPoolMemberPorts;
        private java.lang.Boolean enabled;
        private java.lang.String ipAddress;
        private java.lang.String lbPersistenceProfilePath;
        private java.lang.String lbServicePath;
        private java.lang.Boolean logSignificantEventOnly;
        private java.lang.Long maxConcurrentConnections;
        private java.lang.Long maxNewConnectionRate;
        private java.lang.String poolPath;
        private java.util.List<java.lang.String> ports;
        private java.util.List<com.vmware.nsx_policy.model.LBRule> rules;
        private com.vmware.nsx_policy.model.LBServerSslProfileBinding serverSslProfileBinding;
        private java.lang.String sorryPoolPath;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBVirtualServer}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing which site owns an object.
         * This is used in NSX+.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param originSiteId New value for the property.
         */
        public Builder setOriginSiteId(java.lang.String originSiteId) {
            this.originSiteId = originSiteId;
            return this;
        }

        /**
         * This is a UUID generated by the system for knowing who owns this object. This is
         * used in NSX+.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param ownerId New value for the property.
         */
        public Builder setOwnerId(java.lang.String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * Path of its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param parentPath New value for the property.
         */
        public Builder setParentPath(java.lang.String parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        /**
         * Absolute path of this object
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param path New value for the property.
         */
        public Builder setPath(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * This is a UUID generated by the system for realizing the entity object. In most
         * cases this should be same as 'unique_id' of the entity. However, in some cases
         * this can be different because of entities have migrated their unique identifier
         * to NSX Policy intent objects later in the timeline and did not use unique_id for
         * realization. Realization id is helpful for users to debug data path to correlate
         * the configuration with corresponding intent.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param realizationId New value for the property.
         */
        public Builder setRealizationId(java.lang.String realizationId) {
            this.realizationId = realizationId;
            return this;
        }

        /**
         * Path relative from its parent
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param relativePath New value for the property.
         */
        public Builder setRelativePath(java.lang.String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        /**
         * This is the path of the object on the local managers when queried on the NSX+
         * service, and path of the object on NSX+ service when queried from the local
         * managers.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param remotePath New value for the property.
         */
        public Builder setRemotePath(java.lang.String remotePath) {
            this.remotePath = remotePath;
            return this;
        }

        /**
         * This is a UUID generated by the GM/LM to uniquely identify entities in a
         * federated environment. For entities that are stretched across multiple sites,
         * the same ID will be used on all the stretched sites.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param uniqueId New value for the property.
         */
        public Builder setUniqueId(java.lang.String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        /**
         * Subtree for this type within policy tree containing nested elements. Note that
         * this type is applicable to be used in Hierarchical API only.
         *
         * @param children New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_policy.model.ChildPolicyConfigResource}. When methods return a
         * value of this class as a return value, the property will contain all the
         * properties defined in {@link
         * com.vmware.nsx_policy.model.ChildPolicyConfigResource}.
         */
        public Builder setChildren(java.util.List<com.vmware.vapi.bindings.Structure> children) {
            this.children = children;
            return this;
        }

        /**
         * Intent objects are not directly deleted from the system when a delete is invoked
         * on them. They are marked for deletion and only when all the realized entities
         * for that intent object gets deleted, the intent object is deleted. Objects that
         * are marked for deletion are not returned in GET call. One can use the search API
         * to get these objects.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param markedForDelete New value for the property.
         */
        public Builder setMarkedForDelete(java.lang.Boolean markedForDelete) {
            this.markedForDelete = markedForDelete;
            return this;
        }

        /**
         * Global intent objects cannot be modified by the user. However, certain global
         * intent objects can be overridden locally by use of this property. In such cases,
         * the overridden local values take precedence over the globally defined values for
         * the properties.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param overridden New value for the property.
         */
        public Builder setOverridden(java.lang.Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        /**
         *
         *
         * @param accessListControl New value for the property.
         */
        public Builder setAccessListControl(com.vmware.nsx_policy.model.LBAccessListControl accessListControl) {
            this.accessListControl = accessListControl;
            return this;
        }

        /**
         * If access log is enabled, all HTTP requests sent to L7 virtual server are logged
         * to the access log file. Both successful returns information responses(1xx),
         * successful responses(2xx), redirection messages(3xx) and unsuccessful requests,
         * backend server returns 4xx or 5xx, are logged to access log, if enabled. All L4
         * virtual server connections are also logged to the access log if enabled. The
         * non-significant events such as successful requests are not logged if
         * log_significant_event_only is set to true.
         *
         * @param accessLogEnabled New value for the property.
         */
        public Builder setAccessLogEnabled(java.lang.Boolean accessLogEnabled) {
            this.accessLogEnabled = accessLogEnabled;
            return this;
        }

        /**
         * The application profile defines the application protocol characteristics. It is
         * used to influence how load balancing is performed. Currently, LBFastTCPProfile,
         * LBFastUDPProfile and LBHttpProfile, etc are supported.
         *
         * @param applicationProfilePath New value for the property.
         */
        public Builder setApplicationProfilePath(java.lang.String applicationProfilePath) {
            this.applicationProfilePath = applicationProfilePath;
            return this;
        }

        /**
         *
         *
         * @param clientSslProfileBinding New value for the property.
         */
        public Builder setClientSslProfileBinding(com.vmware.nsx_policy.model.LBClientSslProfileBinding clientSslProfileBinding) {
            this.clientSslProfileBinding = clientSslProfileBinding;
            return this;
        }

        /**
         * Default pool member ports when member port is not defined. format: port-or-range
         *
         * @param defaultPoolMemberPorts New value for the property.
         */
        public Builder setDefaultPoolMemberPorts(java.util.List<java.lang.String> defaultPoolMemberPorts) {
            this.defaultPoolMemberPorts = defaultPoolMemberPorts;
            return this;
        }

        /**
         * Flag to enable the load balancer virtual server.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Configures the IP address of the LBVirtualServer where it receives all client
         * connections and distributes them among the backend servers. format: ip
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Path to optional object that enables persistence on a virtual server allowing
         * related client connections to be sent to the same backend server. Persistence is
         * deactivated by default.
         *
         * @param lbPersistenceProfilePath New value for the property.
         */
        public Builder setLbPersistenceProfilePath(java.lang.String lbPersistenceProfilePath) {
            this.lbPersistenceProfilePath = lbPersistenceProfilePath;
            return this;
        }

        /**
         * virtual servers can be associated to LBService(which is similar to
         * physical/virtual load balancer), LB virtual servers, pools and other entities
         * could be defined independently, the LBService identifier list here would be used
         * to maintain the relationship of LBService and other LB entities.
         *
         * @param lbServicePath New value for the property.
         */
        public Builder setLbServicePath(java.lang.String lbServicePath) {
            this.lbServicePath = lbServicePath;
            return this;
        }

        /**
         * The property log_significant_event_only can take effect only when
         * access_log_enabled is true. If log_significant_event_only is true, significant
         * events are logged in access log. For L4 virtual server, significant event means
         * unsuccessful(error or dropped) TCP/UDP connections. For L7 virtual server,
         * significant event means unsuccessful connections or HTTP/HTTPS requests which
         * have error response code(e.g. 4xx, 5xx).
         *
         * @param logSignificantEventOnly New value for the property.
         */
        public Builder setLogSignificantEventOnly(java.lang.Boolean logSignificantEventOnly) {
            this.logSignificantEventOnly = logSignificantEventOnly;
            return this;
        }

        /**
         * To ensure one virtual server does not over consume resources, affecting other
         * applications hosted on the same LBS, connections to a virtual server can be
         * capped. If it is not specified, it means that connections are unlimited. The
         * property is deprecated as NSX-T Load Balancer is deprecated. format: int64
         *
         * @param maxConcurrentConnections New value for the property.
         */
        public Builder setMaxConcurrentConnections(java.lang.Long maxConcurrentConnections) {
            this.maxConcurrentConnections = maxConcurrentConnections;
            return this;
        }

        /**
         * To ensure one virtual server does not over consume resources, connections to a
         * member can be rate limited. If it is not specified, it means that connection
         * rate is unlimited. The property is deprecated as NSX-T Load Balancer is
         * deprecated. format: int64
         *
         * @param maxNewConnectionRate New value for the property.
         */
        public Builder setMaxNewConnectionRate(java.lang.Long maxNewConnectionRate) {
            this.maxNewConnectionRate = maxNewConnectionRate;
            return this;
        }

        /**
         * The server pool(LBPool) contains backend servers. Server pool consists of one or
         * more servers, also referred to as pool members, that are similarly configured
         * and are running the same application.
         *
         * @param poolPath New value for the property.
         */
        public Builder setPoolPath(java.lang.String poolPath) {
            this.poolPath = poolPath;
            return this;
        }

        /**
         * Ports contains a list of at least one port or port range such as \"80\",
         * \"1234-1236\". Each port element in the list should be a single port or a single
         * port range. format: port-or-range
         *
         * @param ports New value for the property.
         */
        public Builder setPorts(java.util.List<java.lang.String> ports) {
            this.ports = ports;
            return this;
        }

        /**
         * Load balancer rules allow customization of load balancing behavior using
         * match/action rules. Currently, load balancer rules are supported for only layer
         * 7 virtual servers with LBHttpProfile. The property is deprecated as NSX-T Load
         * Balancer is deprecated.
         *
         * @param rules New value for the property.
         */
        public Builder setRules(java.util.List<com.vmware.nsx_policy.model.LBRule> rules) {
            this.rules = rules;
            return this;
        }

        /**
         *
         *
         * @param serverSslProfileBinding New value for the property.
         */
        public Builder setServerSslProfileBinding(com.vmware.nsx_policy.model.LBServerSslProfileBinding serverSslProfileBinding) {
            this.serverSslProfileBinding = serverSslProfileBinding;
            return this;
        }

        /**
         * When load balancer can not select a backend server to serve the request in
         * default pool or pool in rules, the request would be served by sorry server pool.
         * The property is deprecated as NSX-T Load Balancer is deprecated.
         *
         * @param sorryPoolPath New value for the property.
         */
        public Builder setSorryPoolPath(java.lang.String sorryPoolPath) {
            this.sorryPoolPath = sorryPoolPath;
            return this;
        }

        public LBVirtualServer build() {
            LBVirtualServer result = new LBVirtualServer();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setOriginSiteId(this.originSiteId);
            result.setOwnerId(this.ownerId);
            result.setParentPath(this.parentPath);
            result.setPath(this.path);
            result.setRealizationId(this.realizationId);
            result.setRelativePath(this.relativePath);
            result.setRemotePath(this.remotePath);
            result.setUniqueId(this.uniqueId);
            result.setChildren(this.children);
            result.setMarkedForDelete(this.markedForDelete);
            result.setOverridden(this.overridden);
            result.setAccessListControl(this.accessListControl);
            result.setAccessLogEnabled(this.accessLogEnabled);
            result.setApplicationProfilePath(this.applicationProfilePath);
            result.setClientSslProfileBinding(this.clientSslProfileBinding);
            result.setDefaultPoolMemberPorts(this.defaultPoolMemberPorts);
            result.setEnabled(this.enabled);
            result.setIpAddress(this.ipAddress);
            result.setLbPersistenceProfilePath(this.lbPersistenceProfilePath);
            result.setLbServicePath(this.lbServicePath);
            result.setLogSignificantEventOnly(this.logSignificantEventOnly);
            result.setMaxConcurrentConnections(this.maxConcurrentConnections);
            result.setMaxNewConnectionRate(this.maxNewConnectionRate);
            result.setPoolPath(this.poolPath);
            result.setPorts(this.ports);
            result.setRules(this.rules);
            result.setServerSslProfileBinding(this.serverSslProfileBinding);
            result.setSorryPoolPath(this.sorryPoolPath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("origin_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("origin_site_id",
                                                                                "originSiteId",
                                                                                "getOriginSiteId",
                                                                                "setOriginSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("owner_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("owner_id",
                                                                                "ownerId",
                                                                                "getOwnerId",
                                                                                "setOwnerId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("parent_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("parent_path",
                                                                                "parentPath",
                                                                                "getParentPath",
                                                                                "setParentPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("path",
                                                                                "path",
                                                                                "getPath",
                                                                                "setPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("realization_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("realization_id",
                                                                                "realizationId",
                                                                                "getRealizationId",
                                                                                "setRealizationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("relative_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("relative_path",
                                                                                "relativePath",
                                                                                "getRelativePath",
                                                                                "setRelativePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_path",
                                                                                "remotePath",
                                                                                "getRemotePath",
                                                                                "setRemotePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unique_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unique_id",
                                                                                "uniqueId",
                                                                                "getUniqueId",
                                                                                "setUniqueId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("children", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.childPolicyConfigResource; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("children",
                                                                                "children",
                                                                                "getChildren",
                                                                                "setChildren");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("marked_for_delete", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("marked_for_delete",
                                                                                "markedForDelete",
                                                                                "getMarkedForDelete",
                                                                                "setMarkedForDelete");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("overridden", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("overridden",
                                                                                "overridden",
                                                                                "getOverridden",
                                                                                "setOverridden");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("access_list_control", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBAccessListControl; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("access_list_control",
                                                                                "accessListControl",
                                                                                "getAccessListControl",
                                                                                "setAccessListControl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("access_log_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("access_log_enabled",
                                                                                "accessLogEnabled",
                                                                                "getAccessLogEnabled",
                                                                                "setAccessLogEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("application_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("application_profile_path",
                                                                                "applicationProfilePath",
                                                                                "getApplicationProfilePath",
                                                                                "setApplicationProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_ssl_profile_binding", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBClientSslProfileBinding; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_ssl_profile_binding",
                                                                                "clientSslProfileBinding",
                                                                                "getClientSslProfileBinding",
                                                                                "setClientSslProfileBinding");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_pool_member_ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_pool_member_ports",
                                                                                "defaultPoolMemberPorts",
                                                                                "getDefaultPoolMemberPorts",
                                                                                "setDefaultPoolMemberPorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lb_persistence_profile_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lb_persistence_profile_path",
                                                                                "lbPersistenceProfilePath",
                                                                                "getLbPersistenceProfilePath",
                                                                                "setLbPersistenceProfilePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("lb_service_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("lb_service_path",
                                                                                "lbServicePath",
                                                                                "getLbServicePath",
                                                                                "setLbServicePath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("log_significant_event_only", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("log_significant_event_only",
                                                                                "logSignificantEventOnly",
                                                                                "getLogSignificantEventOnly",
                                                                                "setLogSignificantEventOnly");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_concurrent_connections", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_concurrent_connections",
                                                                                "maxConcurrentConnections",
                                                                                "getMaxConcurrentConnections",
                                                                                "setMaxConcurrentConnections");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_new_connection_rate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_new_connection_rate",
                                                                                "maxNewConnectionRate",
                                                                                "getMaxNewConnectionRate",
                                                                                "setMaxNewConnectionRate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pool_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pool_path",
                                                                                "poolPath",
                                                                                "getPoolPath",
                                                                                "setPoolPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ports", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ports",
                                                                                "ports",
                                                                                "getPorts",
                                                                                "setPorts");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rules", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBRule; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rules",
                                                                                "rules",
                                                                                "getRules",
                                                                                "setRules");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("server_ssl_profile_binding", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.LBServerSslProfileBinding; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("server_ssl_profile_binding",
                                                                                "serverSslProfileBinding",
                                                                                "getServerSslProfileBinding",
                                                                                "setServerSslProfileBinding");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sorry_pool_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sorry_pool_path",
                                                                                "sorryPoolPath",
                                                                                "getSorryPoolPath",
                                                                                "setSorryPoolPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.LB_virtual_server",
                                                            fields,
                                                            com.vmware.nsx_policy.model.LBVirtualServer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

