/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * The runtime status of the invocation of an Online Diagnostic System runbook.
 */
public final class OdsRunbookInvocationStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String OPERATION_STATE_NONE = "NONE";

    public static final java.lang.String OPERATION_STATE_RUNBOOK_NOT_FOUND = "RUNBOOK_NOT_FOUND";

    public static final java.lang.String OPERATION_STATE_QUEUED = "QUEUED";

    public static final java.lang.String OPERATION_STATE_BUSY_REJECTED = "BUSY_REJECTED";

    public static final java.lang.String OPERATION_STATE_THROTTLED = "THROTTLED";

    public static final java.lang.String OPERATION_STATE_ARG_INVALID = "ARG_INVALID";

    public static final java.lang.String OPERATION_STATE_RUNNING = "RUNNING";

    public static final java.lang.String OPERATION_STATE_FINISHED = "FINISHED";

    public static final java.lang.String OPERATION_STATE_GENERAL_ERROR = "GENERAL_ERROR";

    public static final java.lang.String OPERATION_STATE_RUNBOOK_NOT_ENABLED = "RUNBOOK_NOT_ENABLED";

    public static final java.lang.String OPERATION_STATE_ABORTED = "ABORTED";

    public static final java.lang.String REQUEST_STATUS_SUCCESS = "SUCCESS";

    public static final java.lang.String REQUEST_STATUS_CONNECTION_ERROR = "CONNECTION_ERROR";

    public static final java.lang.String REQUEST_STATUS_TIMEOUT = "TIMEOUT";

    private java.lang.String operationState;

    private java.lang.String requestStatus;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public OdsRunbookInvocationStatus() {
    }

    protected OdsRunbookInvocationStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNBOOK_NOT_FOUND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_QUEUED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_BUSY_REJECTED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_THROTTLED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_ARG_INVALID}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNNING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_FINISHED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_GENERAL_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNBOOK_NOT_ENABLED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_ABORTED}</li>
     * </ul> Operation state of an invocation of an Online Diagnostic System runbook on
     * its target node. NONE - No operation state is available. RUNBOOK_NOT_FOUND - The
     * specified runbook does not exist on the target. QUEUED - The runbook invocation
     * is queued to be scheduled. BUSY_REJECTED - The runbook invocation is rejected
     * because the runbook runner on the target node is busy. THROTTLED - The runbook
     * invocation is rejected by throttling check. ARG_INVALID - The runbook invocation
     * is rejected by argument validation. RUNNING - The runbook invocation is running.
     * FINISHED - The runbook invocation is finished. GENERAL_ERROR - Runbook
     * invocation fails with some internal errors. RUNBOOK_NOT_ENABLED - The specified
     * runbook is not enabled on the target. ABORTED - The runbook invocation is
     * cancelled.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOperationState() {
        return this.operationState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_NONE}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNBOOK_NOT_FOUND}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_QUEUED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_BUSY_REJECTED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_THROTTLED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_ARG_INVALID}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNNING}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_FINISHED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_GENERAL_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNBOOK_NOT_ENABLED}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_ABORTED}</li>
     * </ul> Operation state of an invocation of an Online Diagnostic System runbook on
     * its target node. NONE - No operation state is available. RUNBOOK_NOT_FOUND - The
     * specified runbook does not exist on the target. QUEUED - The runbook invocation
     * is queued to be scheduled. BUSY_REJECTED - The runbook invocation is rejected
     * because the runbook runner on the target node is busy. THROTTLED - The runbook
     * invocation is rejected by throttling check. ARG_INVALID - The runbook invocation
     * is rejected by argument validation. RUNNING - The runbook invocation is running.
     * FINISHED - The runbook invocation is finished. GENERAL_ERROR - Runbook
     * invocation fails with some internal errors. RUNBOOK_NOT_ENABLED - The specified
     * runbook is not enabled on the target. ABORTED - The runbook invocation is
     * cancelled.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param operationState New value for the property.
     */
    public void setOperationState(java.lang.String operationState) {
        this.operationState = operationState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_CONNECTION_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_TIMEOUT}</li>
     * </ul> Request status of an invocation of an Online Diagnostic System runbook.
     * SUCCESS - The runbook invocation request is acknowledged by the target.
     * CONNECTION_ERROR - The runbook invocation request cannot be dispatched to the
     * target because the messaging channel is broken. TIMEOUT - The runbook invocation
     * request was acknowledged by the target, but it did not report operational state
     * of the terminating class to NSX in time.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRequestStatus() {
        return this.requestStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_CONNECTION_ERROR}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_TIMEOUT}</li>
     * </ul> Request status of an invocation of an Online Diagnostic System runbook.
     * SUCCESS - The runbook invocation request is acknowledged by the target.
     * CONNECTION_ERROR - The runbook invocation request cannot be dispatched to the
     * target because the messaging channel is broken. TIMEOUT - The runbook invocation
     * request was acknowledged by the target, but it did not report operational state
     * of the terminating class to NSX in time.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param requestStatus New value for the property.
     */
    public void setRequestStatus(java.lang.String requestStatus) {
        this.requestStatus = requestStatus;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.odsRunbookInvocationStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("operation_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.operationState, this._getType().getField("operation_state")));
        structValue.setField("request_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.requestStatus, this._getType().getField("request_status")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.odsRunbookInvocationStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.odsRunbookInvocationStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static OdsRunbookInvocationStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new OdsRunbookInvocationStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static OdsRunbookInvocationStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new OdsRunbookInvocationStatus(structValue);
    }

    /**
     * Builder class for {@link OdsRunbookInvocationStatus}.
     */
    public static final class Builder {
        private java.lang.String operationState;
        private java.lang.String requestStatus;

        /**
         * Constructor with parameters for the required properties of
         * {@link OdsRunbookInvocationStatus}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_NONE}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNBOOK_NOT_FOUND}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_QUEUED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_BUSY_REJECTED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_THROTTLED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_ARG_INVALID}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNNING}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_FINISHED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_GENERAL_ERROR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_RUNBOOK_NOT_ENABLED}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#OPERATION_STATE_ABORTED}</li>
         * </ul> Operation state of an invocation of an Online Diagnostic System runbook on
         * its target node. NONE - No operation state is available. RUNBOOK_NOT_FOUND - The
         * specified runbook does not exist on the target. QUEUED - The runbook invocation
         * is queued to be scheduled. BUSY_REJECTED - The runbook invocation is rejected
         * because the runbook runner on the target node is busy. THROTTLED - The runbook
         * invocation is rejected by throttling check. ARG_INVALID - The runbook invocation
         * is rejected by argument validation. RUNNING - The runbook invocation is running.
         * FINISHED - The runbook invocation is finished. GENERAL_ERROR - Runbook
         * invocation fails with some internal errors. RUNBOOK_NOT_ENABLED - The specified
         * runbook is not enabled on the target. ABORTED - The runbook invocation is
         * cancelled.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param operationState New value for the property.
         */
        public Builder setOperationState(java.lang.String operationState) {
            this.operationState = operationState;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_SUCCESS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_CONNECTION_ERROR}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.OdsRunbookInvocationStatus#REQUEST_STATUS_TIMEOUT}</li>
         * </ul> Request status of an invocation of an Online Diagnostic System runbook.
         * SUCCESS - The runbook invocation request is acknowledged by the target.
         * CONNECTION_ERROR - The runbook invocation request cannot be dispatched to the
         * target because the messaging channel is broken. TIMEOUT - The runbook invocation
         * request was acknowledged by the target, but it did not report operational state
         * of the terminating class to NSX in time.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param requestStatus New value for the property.
         */
        public Builder setRequestStatus(java.lang.String requestStatus) {
            this.requestStatus = requestStatus;
            return this;
        }

        public OdsRunbookInvocationStatus build() {
            OdsRunbookInvocationStatus result = new OdsRunbookInvocationStatus();
            result.setOperationState(this.operationState);
            result.setRequestStatus(this.requestStatus);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("operation_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("operation_state",
                                                                                "operationState",
                                                                                "getOperationState",
                                                                                "setOperationState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("request_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("request_status",
                                                                                "requestStatus",
                                                                                "getRequestStatus",
                                                                                "setRequestStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.ods_runbook_invocation_status",
                                                            fields,
                                                            com.vmware.nsx_policy.model.OdsRunbookInvocationStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

