/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Policy Attributes data holder
 */
public final class PolicyAttributes implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ATTRIBUTE_SOURCE_SYSTEM = "SYSTEM";

    public static final java.lang.String ATTRIBUTE_SOURCE_CUSTOM = "CUSTOM";

    public static final java.lang.String DATATYPE_STRING = "STRING";

    public static final java.lang.String KEY_APP_ID = "APP_ID";

    public static final java.lang.String KEY_DOMAIN_NAME = "DOMAIN_NAME";

    public static final java.lang.String KEY_URL_CATEGORY = "URL_CATEGORY";

    public static final java.lang.String KEY_URL_REPUTATION = "URL_REPUTATION";

    public static final java.lang.String KEY_CUSTOM_URL = "CUSTOM_URL";

    private java.lang.String attributeSource;

    private java.lang.Boolean customUrlPartialMatch;

    private java.lang.String datatype;

    private java.lang.String description;

    private java.lang.Boolean isALGType;

    private java.lang.String key;

    private java.util.List<com.vmware.nsx_policy.model.ContextProfileAttributesMetadata> metadata;

    private java.util.List<com.vmware.nsx_policy.model.PolicySubAttributes> subAttributes;

    private java.util.List<java.lang.String> value;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PolicyAttributes() {
    }

    protected PolicyAttributes(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#ATTRIBUTE_SOURCE_SYSTEM}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#ATTRIBUTE_SOURCE_CUSTOM}</li> </ul>
     * Source of attribute value i.e whether system defined or custom value
     *
     * @return The current value of the property.
     */
    public java.lang.String getAttributeSource() {
        return this.attributeSource;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#ATTRIBUTE_SOURCE_SYSTEM}</li> <li>
     * {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#ATTRIBUTE_SOURCE_CUSTOM}</li> </ul>
     * Source of attribute value i.e whether system defined or custom value
     *
     * @param attributeSource New value for the property.
     */
    public void setAttributeSource(java.lang.String attributeSource) {
        this.attributeSource = attributeSource;
    }

    /**
     * True value for this flag will be treated as a partial match for custom url
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getCustomUrlPartialMatch() {
        return this.customUrlPartialMatch;
    }

    /**
     * True value for this flag will be treated as a partial match for custom url
     *
     * @param customUrlPartialMatch New value for the property.
     */
    public void setCustomUrlPartialMatch(java.lang.Boolean customUrlPartialMatch) {
        this.customUrlPartialMatch = customUrlPartialMatch;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#DATATYPE_STRING}</li> </ul>
     * Datatype for attribute
     *
     * @return The current value of the property.
     */
    public java.lang.String getDatatype() {
        return this.datatype;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#DATATYPE_STRING}</li> </ul>
     * Datatype for attribute
     *
     * @param datatype New value for the property.
     */
    public void setDatatype(java.lang.String datatype) {
        this.datatype = datatype;
    }

    /**
     * Description for attribute value
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description for attribute value
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Describes whether the APP_ID value is ALG type or not.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsALGType() {
        return this.isALGType;
    }

    /**
     * Describes whether the APP_ID value is ALG type or not.
     *
     * @param isALGType New value for the property.
     */
    public void setIsALGType(java.lang.Boolean isALGType) {
        this.isALGType = isALGType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#KEY_APP_ID}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#KEY_DOMAIN_NAME}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#KEY_URL_CATEGORY}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#KEY_URL_REPUTATION}</li> <li>
     * {@link com.vmware.nsx_policy.model.PolicyAttributes#KEY_CUSTOM_URL}</li> </ul>
     * URL_Reputation is currently not available. Please do not use it in Attribute Key
     * while creating context profile
     *
     * @return The current value of the property.
     */
    public java.lang.String getKey() {
        return this.key;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#KEY_APP_ID}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#KEY_DOMAIN_NAME}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#KEY_URL_CATEGORY}</li> <li> {@link
     * com.vmware.nsx_policy.model.PolicyAttributes#KEY_URL_REPUTATION}</li> <li>
     * {@link com.vmware.nsx_policy.model.PolicyAttributes#KEY_CUSTOM_URL}</li> </ul>
     * URL_Reputation is currently not available. Please do not use it in Attribute Key
     * while creating context profile
     *
     * @param key New value for the property.
     */
    public void setKey(java.lang.String key) {
        this.key = key;
    }

    /**
     * This is optional part that can hold additional data about the attribute
     * key/values. Example - For URL CATEGORY key , it specified super category for url
     * category value. This is generic array and can hold multiple meta information
     * about key/values in future
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.ContextProfileAttributesMetadata> getMetadata() {
        return this.metadata;
    }

    /**
     * This is optional part that can hold additional data about the attribute
     * key/values. Example - For URL CATEGORY key , it specified super category for url
     * category value. This is generic array and can hold multiple meta information
     * about key/values in future
     *
     * @param metadata New value for the property.
     */
    public void setMetadata(java.util.List<com.vmware.nsx_policy.model.ContextProfileAttributesMetadata> metadata) {
        this.metadata = metadata;
    }

    /**
     * Reference to sub attributes for the attribute
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_policy.model.PolicySubAttributes> getSubAttributes() {
        return this.subAttributes;
    }

    /**
     * Reference to sub attributes for the attribute
     *
     * @param subAttributes New value for the property.
     */
    public void setSubAttributes(java.util.List<com.vmware.nsx_policy.model.PolicySubAttributes> subAttributes) {
        this.subAttributes = subAttributes;
    }

    /**
     * Multiple attribute values can be specified as elements of array.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getValue() {
        return this.value;
    }

    /**
     * Multiple attribute values can be specified as elements of array.
     *
     * @param value New value for the property.
     */
    public void setValue(java.util.List<java.lang.String> value) {
        this.value = value;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyAttributes;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("attribute_source",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.attributeSource, this._getType().getField("attribute_source")));
        structValue.setField("custom_url_partial_match",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.customUrlPartialMatch, this._getType().getField("custom_url_partial_match")));
        structValue.setField("datatype",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.datatype, this._getType().getField("datatype")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("isALGType",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isALGType, this._getType().getField("isALGType")));
        structValue.setField("key",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.key, this._getType().getField("key")));
        structValue.setField("metadata",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.metadata, this._getType().getField("metadata")));
        structValue.setField("sub_attributes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subAttributes, this._getType().getField("sub_attributes")));
        structValue.setField("value",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.value, this._getType().getField("value")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.policyAttributes;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.policyAttributes.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PolicyAttributes _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyAttributes(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PolicyAttributes _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PolicyAttributes(structValue);
    }

    /**
     * Builder class for {@link PolicyAttributes}.
     */
    public static final class Builder {
        private java.lang.String attributeSource;
        private java.lang.Boolean customUrlPartialMatch;
        private java.lang.String datatype;
        private java.lang.String description;
        private java.lang.Boolean isALGType;
        private java.lang.String key;
        private java.util.List<com.vmware.nsx_policy.model.ContextProfileAttributesMetadata> metadata;
        private java.util.List<com.vmware.nsx_policy.model.PolicySubAttributes> subAttributes;
        private java.util.List<java.lang.String> value;

        /**
         * Constructor with parameters for the required properties of
         * {@link PolicyAttributes}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyAttributes#ATTRIBUTE_SOURCE_SYSTEM}</li> <li>
         * {@link
         * com.vmware.nsx_policy.model.PolicyAttributes#ATTRIBUTE_SOURCE_CUSTOM}</li> </ul>
         * Source of attribute value i.e whether system defined or custom value
         *
         * @param attributeSource New value for the property.
         */
        public Builder setAttributeSource(java.lang.String attributeSource) {
            this.attributeSource = attributeSource;
            return this;
        }

        /**
         * True value for this flag will be treated as a partial match for custom url
         *
         * @param customUrlPartialMatch New value for the property.
         */
        public Builder setCustomUrlPartialMatch(java.lang.Boolean customUrlPartialMatch) {
            this.customUrlPartialMatch = customUrlPartialMatch;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyAttributes#DATATYPE_STRING}</li> </ul>
         * Datatype for attribute
         *
         * @param datatype New value for the property.
         */
        public Builder setDatatype(java.lang.String datatype) {
            this.datatype = datatype;
            return this;
        }

        /**
         * Description for attribute value
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Describes whether the APP_ID value is ALG type or not.
         *
         * @param isALGType New value for the property.
         */
        public Builder setIsALGType(java.lang.Boolean isALGType) {
            this.isALGType = isALGType;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.PolicyAttributes#KEY_APP_ID}</li> <li> {@link
         * com.vmware.nsx_policy.model.PolicyAttributes#KEY_DOMAIN_NAME}</li> <li> {@link
         * com.vmware.nsx_policy.model.PolicyAttributes#KEY_URL_CATEGORY}</li> <li> {@link
         * com.vmware.nsx_policy.model.PolicyAttributes#KEY_URL_REPUTATION}</li> <li>
         * {@link com.vmware.nsx_policy.model.PolicyAttributes#KEY_CUSTOM_URL}</li> </ul>
         * URL_Reputation is currently not available. Please do not use it in Attribute Key
         * while creating context profile
         *
         * @param key New value for the property.
         */
        public Builder setKey(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * This is optional part that can hold additional data about the attribute
         * key/values. Example - For URL CATEGORY key , it specified super category for url
         * category value. This is generic array and can hold multiple meta information
         * about key/values in future
         *
         * @param metadata New value for the property.
         */
        public Builder setMetadata(java.util.List<com.vmware.nsx_policy.model.ContextProfileAttributesMetadata> metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Reference to sub attributes for the attribute
         *
         * @param subAttributes New value for the property.
         */
        public Builder setSubAttributes(java.util.List<com.vmware.nsx_policy.model.PolicySubAttributes> subAttributes) {
            this.subAttributes = subAttributes;
            return this;
        }

        /**
         * Multiple attribute values can be specified as elements of array.
         *
         * @param value New value for the property.
         */
        public Builder setValue(java.util.List<java.lang.String> value) {
            this.value = value;
            return this;
        }

        public PolicyAttributes build() {
            PolicyAttributes result = new PolicyAttributes();
            result.setAttributeSource(this.attributeSource);
            result.setCustomUrlPartialMatch(this.customUrlPartialMatch);
            result.setDatatype(this.datatype);
            result.setDescription(this.description);
            result.setIsALGType(this.isALGType);
            result.setKey(this.key);
            result.setMetadata(this.metadata);
            result.setSubAttributes(this.subAttributes);
            result.setValue(this.value);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("attribute_source", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("attribute_source",
                                                                                "attributeSource",
                                                                                "getAttributeSource",
                                                                                "setAttributeSource");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("custom_url_partial_match", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("custom_url_partial_match",
                                                                                "customUrlPartialMatch",
                                                                                "getCustomUrlPartialMatch",
                                                                                "setCustomUrlPartialMatch");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("datatype", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("datatype",
                                                                                "datatype",
                                                                                "getDatatype",
                                                                                "setDatatype");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("isALGType", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("isALGType",
                                                                                "isALGType",
                                                                                "getIsALGType",
                                                                                "setIsALGType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("key", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("key",
                                                                                "key",
                                                                                "getKey",
                                                                                "setKey");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("metadata", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.contextProfileAttributesMetadata; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("metadata",
                                                                                "metadata",
                                                                                "getMetadata",
                                                                                "setMetadata");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sub_attributes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_policy.model.StructDefinitions.policySubAttributes; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sub_attributes",
                                                                                "subAttributes",
                                                                                "getSubAttributes",
                                                                                "setSubAttributes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("value", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("value",
                                                                                "value",
                                                                                "getValue",
                                                                                "setValue");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.policy_attributes",
                                                            fields,
                                                            com.vmware.nsx_policy.model.PolicyAttributes.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

