/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * Sub-Cluster-info contains the sub-cluster type and the discovered node IDs for
 * the hosts that belong to this sub-cluster.
 */
public final class SubClusterInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SUB_CLUSTER_TYPE_MANUAL = "MANUAL";

    private java.util.List<java.lang.String> discoveredNodeIds;

    private java.lang.String subClusterType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public SubClusterInfo() {
    }

    protected SubClusterInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Discovered node IDs under this sub-cluster. This is an optional field.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDiscoveredNodeIds() {
        return this.discoveredNodeIds;
    }

    /**
     * Discovered node IDs under this sub-cluster. This is an optional field.
     *
     * @param discoveredNodeIds New value for the property.
     */
    public void setDiscoveredNodeIds(java.util.List<java.lang.String> discoveredNodeIds) {
        this.discoveredNodeIds = discoveredNodeIds;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.SubClusterInfo#SUB_CLUSTER_TYPE_MANUAL}</li> </ul>
     * Sub-cluster-type can be either MANUAL or FAULT_DOMAIN. This is a mandatory
     * field. Currently, all sub-clusters will be of type MANUAL. In the future, we
     * will provide support for creating a sub-cluster for fault domains in VC. This
     * field indicates the same.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSubClusterType() {
        return this.subClusterType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.SubClusterInfo#SUB_CLUSTER_TYPE_MANUAL}</li> </ul>
     * Sub-cluster-type can be either MANUAL or FAULT_DOMAIN. This is a mandatory
     * field. Currently, all sub-clusters will be of type MANUAL. In the future, we
     * will provide support for creating a sub-cluster for fault domains in VC. This
     * field indicates the same.
     *
     * @param subClusterType New value for the property.
     */
    public void setSubClusterType(java.lang.String subClusterType) {
        this.subClusterType = subClusterType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.subClusterInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("discovered_node_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.discoveredNodeIds, this._getType().getField("discovered_node_ids")));
        structValue.setField("sub_cluster_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.subClusterType, this._getType().getField("sub_cluster_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.subClusterInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.subClusterInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static SubClusterInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new SubClusterInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static SubClusterInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new SubClusterInfo(structValue);
    }

    /**
     * Builder class for {@link SubClusterInfo}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> discoveredNodeIds;
        private java.lang.String subClusterType;

        /**
         * Constructor with parameters for the required properties of
         * {@link SubClusterInfo}.
         */
        public Builder() {
        }

        /**
         * Discovered node IDs under this sub-cluster. This is an optional field.
         *
         * @param discoveredNodeIds New value for the property.
         */
        public Builder setDiscoveredNodeIds(java.util.List<java.lang.String> discoveredNodeIds) {
            this.discoveredNodeIds = discoveredNodeIds;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.SubClusterInfo#SUB_CLUSTER_TYPE_MANUAL}</li> </ul>
         * Sub-cluster-type can be either MANUAL or FAULT_DOMAIN. This is a mandatory
         * field. Currently, all sub-clusters will be of type MANUAL. In the future, we
         * will provide support for creating a sub-cluster for fault domains in VC. This
         * field indicates the same.
         *
         * @param subClusterType New value for the property.
         */
        public Builder setSubClusterType(java.lang.String subClusterType) {
            this.subClusterType = subClusterType;
            return this;
        }

        public SubClusterInfo build() {
            SubClusterInfo result = new SubClusterInfo();
            result.setDiscoveredNodeIds(this.discoveredNodeIds);
            result.setSubClusterType(this.subClusterType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("discovered_node_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("discovered_node_ids",
                                                                                "discoveredNodeIds",
                                                                                "getDiscoveredNodeIds",
                                                                                "setDiscoveredNodeIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sub_cluster_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sub_cluster_type",
                                                                                "subClusterType",
                                                                                "getSubClusterType",
                                                                                "setSubClusterType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.sub_cluster_info",
                                                            fields,
                                                            com.vmware.nsx_policy.model.SubClusterInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

