/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_policy.model;

/**
 * List all the TNs spaned in L3PortMirrorSession mirror stack health status.
 */
public final class TnNodeStackSpanStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String DEDICATED_STACK_STATUS_UNKNOWN = "UNKNOWN";

    public static final java.lang.String DEDICATED_STACK_STATUS_SUCCESS = "SUCCESS";

    public static final java.lang.String DEDICATED_STACK_STATUS_FAILED = "FAILED";

    public static final java.lang.String VMKNIC_STATUS_UNKNOWN = "UNKNOWN";

    public static final java.lang.String VMKNIC_STATUS_SUCCESS = "SUCCESS";

    public static final java.lang.String VMKNIC_STATUS_FAILED = "FAILED";

    private java.lang.String dedicatedStackStatus;

    private java.lang.String detail;

    private java.lang.Long lastUpdatedTime;

    private java.lang.String tnNodeId;

    private java.lang.String tnNodeName;

    private java.lang.String vmknicStatus;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TnNodeStackSpanStatus() {
    }

    protected TnNodeStackSpanStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_UNKNOWN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_FAILED}</li>
     * </ul> Show the dedicated mirror stack health status, if the TN node has the
     * mirror stack, it will show SUCCESS or it will show FAILED.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDedicatedStackStatus() {
        return this.dedicatedStackStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_UNKNOWN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_FAILED}</li>
     * </ul> Show the dedicated mirror stack health status, if the TN node has the
     * mirror stack, it will show SUCCESS or it will show FAILED.
     *
     * @param dedicatedStackStatus New value for the property.
     */
    public void setDedicatedStackStatus(java.lang.String dedicatedStackStatus) {
        this.dedicatedStackStatus = dedicatedStackStatus;
    }

    /**
     * Give the detail info for mirror stack and vmknic health status. If the stack or
     * vmknic is FAILED, detail info will tell user reason why the stauts is FAILED. So
     * that user can correct their configuration.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDetail() {
        return this.detail;
    }

    /**
     * Give the detail info for mirror stack and vmknic health status. If the stack or
     * vmknic is FAILED, detail info will tell user reason why the stauts is FAILED. So
     * that user can correct their configuration.
     *
     * @param detail New value for the property.
     */
    public void setDetail(java.lang.String detail) {
        this.detail = detail;
    }

    /**
     * TN miror stack status will be updated periodically, this item indicates the
     * lastest timestamp of TN node stack status is updated. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    /**
     * TN miror stack status will be updated periodically, this item indicates the
     * lastest timestamp of TN node stack status is updated. format: int64
     *
     * @param lastUpdatedTime New value for the property.
     */
    public void setLastUpdatedTime(java.lang.Long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    /**
     * For L3PortMirrorSession configured mirror stack, show the TN node UUID which
     * spaned in L3PortMirrorSession.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTnNodeId() {
        return this.tnNodeId;
    }

    /**
     * For L3PortMirrorSession configured mirror stack, show the TN node UUID which
     * spaned in L3PortMirrorSession.
     *
     * @param tnNodeId New value for the property.
     */
    public void setTnNodeId(java.lang.String tnNodeId) {
        this.tnNodeId = tnNodeId;
    }

    /**
     * For L3PortMirrorSession configured mirror stack, show the TN node friendly name
     * which spaned in L3PortMirrorSession.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTnNodeName() {
        return this.tnNodeName;
    }

    /**
     * For L3PortMirrorSession configured mirror stack, show the TN node friendly name
     * which spaned in L3PortMirrorSession.
     *
     * @param tnNodeName New value for the property.
     */
    public void setTnNodeName(java.lang.String tnNodeName) {
        this.tnNodeName = tnNodeName;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_UNKNOWN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_FAILED}</li>
     * </ul> Show the vmknic health status, if the vmknic has been bouned to mirror
     * stack, it will show SUCCESS or it will show FAILED.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVmknicStatus() {
        return this.vmknicStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_UNKNOWN}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_SUCCESS}</li>
     * <li> {@link
     * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_FAILED}</li>
     * </ul> Show the vmknic health status, if the vmknic has been bouned to mirror
     * stack, it will show SUCCESS or it will show FAILED.
     *
     * @param vmknicStatus New value for the property.
     */
    public void setVmknicStatus(java.lang.String vmknicStatus) {
        this.vmknicStatus = vmknicStatus;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_policy.model.StructDefinitions.tnNodeStackSpanStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dedicated_stack_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dedicatedStackStatus, this._getType().getField("dedicated_stack_status")));
        structValue.setField("detail",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.detail, this._getType().getField("detail")));
        structValue.setField("last_updated_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastUpdatedTime, this._getType().getField("last_updated_time")));
        structValue.setField("tn_node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tnNodeId, this._getType().getField("tn_node_id")));
        structValue.setField("tn_node_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tnNodeName, this._getType().getField("tn_node_name")));
        structValue.setField("vmknic_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmknicStatus, this._getType().getField("vmknic_status")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_policy.model.StructDefinitions.tnNodeStackSpanStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_policy.model.StructDefinitions.tnNodeStackSpanStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TnNodeStackSpanStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TnNodeStackSpanStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TnNodeStackSpanStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TnNodeStackSpanStatus(structValue);
    }

    /**
     * Builder class for {@link TnNodeStackSpanStatus}.
     */
    public static final class Builder {
        private java.lang.String dedicatedStackStatus;
        private java.lang.String detail;
        private java.lang.Long lastUpdatedTime;
        private java.lang.String tnNodeId;
        private java.lang.String tnNodeName;
        private java.lang.String vmknicStatus;

        /**
         * Constructor with parameters for the required properties of
         * {@link TnNodeStackSpanStatus}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_UNKNOWN}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_SUCCESS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#DEDICATED_STACK_STATUS_FAILED}</li>
         * </ul> Show the dedicated mirror stack health status, if the TN node has the
         * mirror stack, it will show SUCCESS or it will show FAILED.
         *
         * @param dedicatedStackStatus New value for the property.
         */
        public Builder setDedicatedStackStatus(java.lang.String dedicatedStackStatus) {
            this.dedicatedStackStatus = dedicatedStackStatus;
            return this;
        }

        /**
         * Give the detail info for mirror stack and vmknic health status. If the stack or
         * vmknic is FAILED, detail info will tell user reason why the stauts is FAILED. So
         * that user can correct their configuration.
         *
         * @param detail New value for the property.
         */
        public Builder setDetail(java.lang.String detail) {
            this.detail = detail;
            return this;
        }

        /**
         * TN miror stack status will be updated periodically, this item indicates the
         * lastest timestamp of TN node stack status is updated. format: int64
         *
         * @param lastUpdatedTime New value for the property.
         */
        public Builder setLastUpdatedTime(java.lang.Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        /**
         * For L3PortMirrorSession configured mirror stack, show the TN node UUID which
         * spaned in L3PortMirrorSession.
         *
         * @param tnNodeId New value for the property.
         */
        public Builder setTnNodeId(java.lang.String tnNodeId) {
            this.tnNodeId = tnNodeId;
            return this;
        }

        /**
         * For L3PortMirrorSession configured mirror stack, show the TN node friendly name
         * which spaned in L3PortMirrorSession.
         *
         * @param tnNodeName New value for the property.
         */
        public Builder setTnNodeName(java.lang.String tnNodeName) {
            this.tnNodeName = tnNodeName;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_UNKNOWN}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_SUCCESS}</li>
         * <li> {@link
         * com.vmware.nsx_policy.model.TnNodeStackSpanStatus#VMKNIC_STATUS_FAILED}</li>
         * </ul> Show the vmknic health status, if the vmknic has been bouned to mirror
         * stack, it will show SUCCESS or it will show FAILED.
         *
         * @param vmknicStatus New value for the property.
         */
        public Builder setVmknicStatus(java.lang.String vmknicStatus) {
            this.vmknicStatus = vmknicStatus;
            return this;
        }

        public TnNodeStackSpanStatus build() {
            TnNodeStackSpanStatus result = new TnNodeStackSpanStatus();
            result.setDedicatedStackStatus(this.dedicatedStackStatus);
            result.setDetail(this.detail);
            result.setLastUpdatedTime(this.lastUpdatedTime);
            result.setTnNodeId(this.tnNodeId);
            result.setTnNodeName(this.tnNodeName);
            result.setVmknicStatus(this.vmknicStatus);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dedicated_stack_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dedicated_stack_status",
                                                                                "dedicatedStackStatus",
                                                                                "getDedicatedStackStatus",
                                                                                "setDedicatedStackStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("detail", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("detail",
                                                                                "detail",
                                                                                "getDetail",
                                                                                "setDetail");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_updated_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_updated_time",
                                                                                "lastUpdatedTime",
                                                                                "getLastUpdatedTime",
                                                                                "setLastUpdatedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tn_node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tn_node_id",
                                                                                "tnNodeId",
                                                                                "getTnNodeId",
                                                                                "setTnNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tn_node_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tn_node_name",
                                                                                "tnNodeName",
                                                                                "getTnNodeName",
                                                                                "setTnNodeName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vmknic_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vmknic_status",
                                                                                "vmknicStatus",
                                                                                "getVmknicStatus",
                                                                                "setVmknicStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_policy.model.tn_node_stack_span_status",
                                                            fields,
                                                            com.vmware.nsx_policy.model.TnNodeStackSpanStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

