/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.infra.realized_state.virtual_machines.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.infra.realized_state.virtual_machines;

public interface Tags extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.infra.realized_state.virtual_machines.TagsTypes {

    /**
     * Allows an admin to apply multiple tags to a virtual machine. This operation does
     * not store the intent on the policy side. It applies the tag directly on the
     * specified enforcement point. This operation will replace the existing tags on
     * the virtual machine with the ones that have been passed. If the application of
     * tag fails on the enforcement point, then an error is reported. The admin will
     * have to retry the operation again. Policy framework does not perform a retry.
     * Failure could occur due to multiple reasons. For e.g enforcement point is down,
     * Enforcement point could not apply the tag due to constraints like max tags limit
     * exceeded, etc. NOTE: The \"virtual_machine_id\" field in the payload will be
     * ignored and the virtual machine ID provided in the URL will be honored.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param virtualMachineId (required)
     * @param virtualMachineTagsUpdate (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String orgId, java.lang.String projectId, java.lang.String virtualMachineId, com.vmware.nsx_policy.model.VirtualMachineTagsUpdate virtualMachineTagsUpdate, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Allows an admin to apply multiple tags to a virtual machine. This operation does
     * not store the intent on the policy side. It applies the tag directly on the
     * specified enforcement point. This operation will replace the existing tags on
     * the virtual machine with the ones that have been passed. If the application of
     * tag fails on the enforcement point, then an error is reported. The admin will
     * have to retry the operation again. Policy framework does not perform a retry.
     * Failure could occur due to multiple reasons. For e.g enforcement point is down,
     * Enforcement point could not apply the tag due to constraints like max tags limit
     * exceeded, etc. NOTE: The \"virtual_machine_id\" field in the payload will be
     * ignored and the virtual machine ID provided in the URL will be honored.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param virtualMachineId (required)
     * @param virtualMachineTagsUpdate (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String orgId, java.lang.String projectId, java.lang.String virtualMachineId, com.vmware.nsx_policy.model.VirtualMachineTagsUpdate virtualMachineTagsUpdate, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Allows an admin to apply multiple tags to a virtual machine. This operation does
     * not store the intent on the policy side. It applies the tag directly on the
     * specified enforcement point. This operation will replace the existing tags on
     * the virtual machine with the ones that have been passed. If the application of
     * tag fails on the enforcement point, then an error is reported. The admin will
     * have to retry the operation again. Policy framework does not perform a retry.
     * Failure could occur due to multiple reasons. For e.g enforcement point is down,
     * Enforcement point could not apply the tag due to constraints like max tags limit
     * exceeded, etc. NOTE: The \"virtual_machine_id\" field in the payload will be
     * ignored and the virtual machine ID provided in the URL will be honored.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param virtualMachineId (required)
     * @param virtualMachineTagsUpdate (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String orgId, java.lang.String projectId, java.lang.String virtualMachineId, com.vmware.nsx_policy.model.VirtualMachineTagsUpdate virtualMachineTagsUpdate, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Allows an admin to apply multiple tags to a virtual machine. This operation does
     * not store the intent on the policy side. It applies the tag directly on the
     * specified enforcement point. This operation will replace the existing tags on
     * the virtual machine with the ones that have been passed. If the application of
     * tag fails on the enforcement point, then an error is reported. The admin will
     * have to retry the operation again. Policy framework does not perform a retry.
     * Failure could occur due to multiple reasons. For e.g enforcement point is down,
     * Enforcement point could not apply the tag due to constraints like max tags limit
     * exceeded, etc. NOTE: The \"virtual_machine_id\" field in the payload will be
     * ignored and the virtual machine ID provided in the URL will be honored.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param virtualMachineId (required)
     * @param virtualMachineTagsUpdate (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String orgId, java.lang.String projectId, java.lang.String virtualMachineId, com.vmware.nsx_policy.model.VirtualMachineTagsUpdate virtualMachineTagsUpdate, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
