/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.orgs.projects.infra.tier_1s.segments.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.orgs.projects.infra.tier_1s.segments;

public interface MacTable extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.orgs.projects.infra.tier_1s.segments.MacTableTypes {

    /**
     * Returns MAC table for a segment
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @return com.vmware.nsx_policy.model.SegmentMacAddressListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SegmentMacAddressListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId);

    /**
     * Returns MAC table for a segment
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.SegmentMacAddressListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.SegmentMacAddressListResult list(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns MAC table for a segment
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentMacAddressListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentMacAddressListResult> asyncCallback);

    /**
     * Returns MAC table for a segment
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.SegmentMacAddressListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param orgId The organization ID (required)
     * @param projectId The project ID (required)
     * @param tier1Id (required)
     * @param segmentId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param source Data source type. (optional)
     * @param transportNodeId TransportNode Id (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String orgId, java.lang.String projectId, java.lang.String tier1Id, java.lang.String segmentId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String source, java.lang.String transportNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.SegmentMacAddressListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
