/* ***************************************************************************
 * Copyright (c) 2020 VMware, Inc. All rights reserved. -- VMware Confidential
 * ***************************************************************************/
package com.vmware.vapi.bindings;

import org.reactivestreams.Publisher;

import com.vmware.vapi.bindings.client.InvocationConfig;

/**
 * Describes the invoke methods of streaming none task vAPI operation.
 * @param <T> return type of the operation.
 */
public interface StreamInvocable<T> {
    /**
     * Streaming method.
     * @return {@link Publisher} which holds the result of the operation invocation.
     */
    public Publisher<T> invoke();

    /**
     * Streaming method with {@link InvocationConfig}.
     * @param invocationConfig used for the operation invocation.
     * @return {@link Publisher} which holds the result of the operation invocation.
     */
    public Publisher<T> invoke(InvocationConfig config);
}
