/* *********************************************************************************
 * Copyright (c) 2018, 2020 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************************************/

package com.vmware.vapi.bindings;

import com.vmware.vapi.bindings.type.Type;

/**
 * This class is used to hold taskId and return type of the operations.
 * Objects of this class are returned from {@code invoke} methods in {@link TaskInvocable}.
 *
 * @param <T> real return type of the operation.
 */
public class Task<T> {
    private final String taskId;
    private final Type resultType;

    public Task(String taskId, Type resultType) {
        this.taskId = taskId;
        this.resultType = resultType;
    }

    public String getTaskId() {
        return taskId;
    }

    public Type getType() {
        return resultType;
    }
}
