/* **********************************************************
 * Copyright 2015 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.bindings.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to specify the API component name. Used on Java
 * packages in generated language bindings.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PACKAGE)
public @interface PackageOf {
    /**
     * The component name for the bindings package.
     *
     * @return string representing the component name
     */
    String value();
}
