/* **********************************************************
 * Copyright (c) 2018 VMware, Inc. All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.bindings.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.vmware.vapi.provider.ApiInterface;

/**
 * Annotation used to specify the API interface implementation. Used on Java service provider
 * packages in generated language bindings.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ProviderFor {
    Class<? extends ApiInterface> value();
}