/* ***************************************************************************
 * Copyright 2014 VMware, Inc.  All rights reserved. -- VMware Confidential
 * ***************************************************************************/

package com.vmware.vapi.config;

import java.util.LinkedList;
import java.util.List;

/**
 * Utility class containing a helper method for joining multiple lists.
 */
public class ListHelper {
    /**
     * Helper method for joining multiple lists.
     * @param lists is a list of lists
     * @return a concatenated list of all elements in the lists parameter
     */
    public static <T> List<T> join(List<List<T>> lists) {
        List<T> result = new LinkedList<T>();
        for (List<T> t : lists) {
            result.addAll(t);
        }
        return result;
    }
}
