/* **********************************************************
 * Copyright 2011-2012 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * InterfaceIdentifier.java --
 *
 *      Interface identifier class.
 */

package com.vmware.vapi.core;


/**
 * The <code>InterfaceIdentifier</code> class identifies an
 * <code>{@link com.vmware.vapi.provider.ApiInterface}</code>
 * instance.
 */
public class InterfaceIdentifier {
    private String iface;

    /**
     * Constructor.
     *
     * @param iface  interface name
     * @throws NullPointerException if <code>iface</code> is <code>null</code>
     */
    public InterfaceIdentifier(String iface) {
        if (iface == null) {
            throw new NullPointerException("iface must be not null");
        }
        this.iface = iface;
    }

    /**
     * Returns the name of this interface.
     *
     * @return  interface name
     */
    public String getName() {
        return iface;
    }

    /** {@inheritDoc} */
    @Override
    public boolean equals(Object o) {
        if (o instanceof InterfaceIdentifier) {
            InterfaceIdentifier tmp = (InterfaceIdentifier) o;
            return iface.equals(tmp.iface);
        }
        return false;
    }

    /** {@inheritDoc} */
    @Override
    public int hashCode() {
        return iface.hashCode();
    }

    /** {@inheritDoc} */
    @Override
    public String toString() {
        return iface;
    }
}