/* **********************************************************
 * Copyright 2011-2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * BooleanDefinition.java --
 *
 *      Type definition for vAPI boolean built-in type
 */

package com.vmware.vapi.data;

public class BooleanDefinition extends DataDefinition{
    private static BooleanDefinition instance = new BooleanDefinition();

    private BooleanDefinition() {
    }

    public static BooleanDefinition getInstance() {
        return instance;
    }

    @Override
    public DataType getType() {
        return DataType.BOOLEAN;
    }

    @Override
    public String toString() {
        return "Boolean";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }

}
