/* **********************************************************
 * Copyright 2011-2013, 2022 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * DataType.java --
 *
 *      Enumeration for build-in vAPI types
 */
package com.vmware.vapi.data;

/**
 * Enumeration for build-in vAPI types.
 *
 */
public enum DataType {
    VOID("VOID"),
    INTEGER("INTEGER"),
    DOUBLE("DOUBLE"),
    BOOLEAN("BOOLEAN"),
    BLOB("BINARY"),
    STRING("STRING"),
    ERROR("ERROR"),
    OPTIONAL("OPTIONAL"),
    LIST("LIST"),
    STRUCTURE("STRUCTURE"),
    OPAQUE("OPAQUE"),
    SECRET("SECRET"),
    STRUCTURE_REF("STRUCTURE_REF"),
    DYNAMIC_STRUCTURE("DYNAMIC_STRUCTURE"),
    ANY_ERROR("ANY_ERROR");

    private final String typeName;

    DataType(String typeName) {
        this.typeName = typeName;
    }

    public String getValue() {
        return typeName;
    }

    public int getIntValue() {
        return ordinal();
    }

    @Override
    public String toString() {
        return typeName;
    }
}
