/* **********************************************************
 * Copyright 2012-2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.data;

public final class DoubleValue implements DataValue {

    private static final long serialVersionUID = 1L;
    private final double value;

    public DoubleValue(double value) {
        this.value = value;
    }

    @Override
    public DataType getType() {
        return DataType.DOUBLE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DoubleValue) {
            DoubleValue doub = (DoubleValue) o;
            return Double.valueOf(value).equals(doub.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Double.valueOf(value).hashCode();
    }

    @Override
    public String toString() {
        return Double.toString(value);
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public DoubleValue copy() {
        return this;
    }
}
