/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ErrorDefinition.java --
 *
 *      Type definition for vAPI error type
 */
package com.vmware.vapi.data;

import java.util.Map;

/**
 * <code>DataDefinitions</code> implementation for vAPI errors.
 */
public class ErrorDefinition extends StructDefinition {

    /**
     * Constructor.
     *
     * <p>Creates instance for the specified name and structure' fields. The
     * name and fields are used for the<code>StructDefinition</code>
     * represented by the instance.
     *
     * @param name the error name; must not be <code>null</code>
     * @param fields <code>Map<code> of name keys and <code>DataDefinition</code>
     *               values for the fields of this instance; must not be
     *               <code>null</code>
     */
    public ErrorDefinition(String name, Map<String, DataDefinition> fields) {
        super(name, fields);
    }

    @Override
    public DataType getType() {
        return DataType.ERROR;
    }

    @Override
    public ErrorValue newInstance() {
        return new ErrorValue(getName());
    }
}
