/* **********************************************************
 * Copyright 2011-2013 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * IntegerDefinition.java --
 *
 *      Type definition for vAPI integer built-in type
 */

package com.vmware.vapi.data;

public class IntegerDefinition extends DataDefinition {
    private static final IntegerDefinition INSTANCE = new IntegerDefinition();

    private IntegerDefinition() {
    }

    public static IntegerDefinition getInstance() {
        return INSTANCE;
    }

    @Override
    public DataType getType() {
        return DataType.INTEGER;
    }

    @Override
    public String toString() {
        return "Integer";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}
