/* **********************************************************
 * Copyright 2011-2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * SecretDefinition.java --
 *
 *      Type definition for vAPI secret built-in type
 */

package com.vmware.vapi.data;

public class SecretDefinition extends DataDefinition {
    private static SecretDefinition instance = new SecretDefinition();

    private SecretDefinition() {
    }

    public static SecretDefinition getInstance() {
        return instance;
    }

    public DataType getType() {
        return DataType.SECRET;
    }

    @Override
    public String toString() {
        return "Secret";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}
