package com.vmware.vapi.data;


import com.vmware.vapi.*;

public class VoidDefinition extends DataDefinition {
    private static VoidDefinition instance = new VoidDefinition();

    private VoidDefinition() {
    }

    public static VoidDefinition getInstance() {
        return instance;
    }

    @Override
    public DataType getType() {
        return DataType.VOID;
    }

    @Override
    public String toString() {
        return "Void";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}
