/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.bindings.convert;

import com.vmware.vapi.bindings.type.Type;

/**
 * Policy which resolves a fully-qualified canonical type name to a type
 * descriptor. The type name can be a structure name or an error name.
 */
public interface NameToTypeResolver {

    /**
     * Resolves the specified type name.
     *
     * @param name fully-qualified canonical name; must not be
     *              <code>null</code> or empty
     * @return type descriptor or <code>null</code> if the name cannot be
     *          resolved
     * @throws IllegalArgumentException if the name is invalid
     */
    Type resolve(String name);
}
