/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * JavaLangStringStringConverter.java --
 *
 *      Convert string type to java.lang.String
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert string type to java.lang.String.
 */
public final class JavaLangStringStringConverter implements
        PrimitiveConverter<StringValue> {

    @Override
    public String fromValue(StringValue value) {
        return value.getValue();
    }

    @Override
    public StringValue toValue(Object primitiveBinding) {
        String bind = ConvertUtil.narrowType(primitiveBinding, String.class);
        return new StringValue(bind);
    }

}
