/* **********************************************************
 * Copyright (c) 2017 VMware, Inc. All rights reserved. VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.bindings.convert.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;

import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;
import com.vmware.vapi.internal.util.Rfc3339DateTimeConverter;

/**
 * Converts <em>DateTime</em> type to {@link java.util.Calendar}.
 * <p>
 * {@link PrimitiveConverter} implementation for DateTime. Also see
 * {@link Rfc3339DateTimeConverter}.
 */
public final class JavaUtilCalendarRfc3339DateTimeConverter implements
        GregorianCalendarConverter {

    private final Rfc3339DateTimeConverter converter =
            new Rfc3339DateTimeConverter();

    @Override
    public GregorianCalendar fromValue(StringValue value) {
        return converter.fromStringValue(value.getValue());
    }

    @Override
    public StringValue toValue(Object primitiveBinding) {
        Calendar calendar = ConvertUtil.narrowType(primitiveBinding,
                                                   Calendar.class);
        return new StringValue(converter.toStringValue(calendar));
    }
}
