/* **********************************************************
 * Copyright (c) 2015-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import java.util.List;
import java.util.Map;

import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest.HttpMethod;

/**
 * Interface defining the REST metadata of an operation.
 */
public interface OperationRestMetadata {

    /**
     * @return mapping of URL path variable placeholders to vAPI operation input field names. The
     *         map may be empty but never <code>null</code>.
     */
    public Map<String, String> getPathVariablesToFieldNames();

    /**
     * @return mapping of request(query) parameters to vAPI operation input field names. The map may
     *         be empty but never <code>null</code>.
     */
    public Map<String, String> getRequestParamsToFieldNames();

    /**
     * @return mapping of request(query) parameters to vAPI operation input field names. The map may
     *         be empty but never <code>null</code>.
     */
    public Map<String, String> getRequestHeadersToFieldNames();

    /**
     * @return HTTP method verb for the vAPI operation. Must not be <code>null</code>.
     */
    public HttpMethod getMethod();

    /**
     * @return URL path template for the vAPI operation. Must not be <code>null</code>.
     */
    public String getUrlTemplate();

    /**
     * @return the field name of the request body parameter of the vAPI operation input. May be
     *         <code>null</code> when the operation has no request body.
     */
    public String getRequestBodyFieldName();

    /**
     * @return the HTTP accept header value for the vAPI operation. May be <code>null</code>.
     */
    public String getAccept();

    /**
     * @return the HTTP content type header value for the vAPI operation. May be <code>null</code>.
     */
    public String getContentType();

    /**
     * @return fixed HTTP request headers for the vAPI operation. May be empty map but never
     *         <code>null</code>.
     */
    public Map<String, List<String>> getFixedHeaders();
}
